/********************************************************************
        Actel APA Verilog Library
        NAME: apa.v
        DATE: March 08, 2006
*********************************************************************/

`timescale 1 ns / 100 ps

//----------------------------------------------------------------------
//---            VERILOG LIBRRAY PRIMITIVE SECTION                     
//----------------------------------------------------------------------

 //---------------------------------------------------------------------
 // primitibe module (Dffpr) state table definition
 // FUNCTION : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
 //            ASYNCHRONOUS SET AND CLEAR. CLR PRIORITY WHEN BOTH
 //            SET AND CLEAR ARE LOW ( Q OUTPUT UDP ).
 //            Enable active low.

 //----------------------------------------------------------------------
primitive Dffpr (Q, D, CLK, CLR, PRE, E, NOTIFIER_REG);
  output Q;
  input  NOTIFIER_REG;
  input  D, CLK, E, CLR, PRE;
  reg Q;

	table

	//  D   CLK   CLR  PRE   E  NOTIFIER_REG  :   Qt  :  Qt+1

	    1   (01)    1   1    0      ?         :   ?   :   1;  // clocked data
	    0   (01)    1   1    0      ?         :   ?   :   0;  // clocked data
	    1   (01)    1   1    x      ?         :   1   :   1;  // clocked data
	    0   (01)    1   1    x      ?         :   0   :   0; 
	    0   (01)    1   1    x      ?         :   1   :   x;
	    1   (01)    1   1    x      ?         :   0   :   x;
	    0   (01)    x   1    0      ?         :   ?   :   0;  // pessimism
	    1   (01)    1   x    0      ?         :   ?   :   1;  // pessimism
	    ?    ?      1   x    ?      ?         :   1   :   1;  // pessimism
	    0    ?      1   x    ?      ?         :   x   :   x;  // pessimism
	    ?    ?      1   x    ?      ?         :   0   :   x;
	    ?    ?      x   x    ?      ?         :   ?   :   x;
	    ?    ?      x   0    ?      ?         :   ?   :   x;
	    ?    ?      x   1    ?      ?         :   0   :   0;
	    ?    ?      x   1    ?      ?         :   1   :   x;
	    ?    ?      0   ?    ?      ?         :   ?   :   0;
	    ?    ?      1   0    ?      ?         :   ?   :   1;
	    1   (x1)    1   1    0      ?         :   1   :   1;  // reducing pessimism
	    0   (x1)    1   1    0      ?         :   0   :   0;
	    1   (0x)    1   1    0      ?         :   1   :   1;
     0   (0x)    1   1    0      ?         :   0   :   0;
	    1   (x1)    1   1    x      ?         :   1   :   1;  // reducing pessimism
	    0   (x1)    1   1    x      ?         :   0   :   0;
	    1   (0x)    1   1    x      ?         :   1   :   1;
	    0   (0x)    1   1    x      ?         :   0   :   0;
	    ?  (?1)     1   1    1      ?         :   ?   :   -;  //no action for CE = 1
	    ?  (0x)     1   1    1      ?         :   ?   :   -;  //no action for CE = 1
	    ?   ?       ?   ?    *      ?         :   ?   :   -;
	    ?   (?0)    ?   ?    ?      ?         :   ?   :   -;  // ignore falling clock
	    ?   (1x)    ?   ?    ?      ?         :   ?   :   -;  // ignore falling clock
	    *    ?      ?   ?    ?      ?         :   ?   :   -;  // ignore data edges
	    ?   ?     (?1)  ?    ?      ?         :   ?   :   -;  // ignore the edges on
	    ?   ?       ?  (?1)  ?      ?         :   ?   :   -;  //       set and clear
	    ?   ?       ?   ?    ?      *         :   ?   :   x;

	endtable
 endprimitive


 //---------------------------------------------------------------------
 // primitibe module (Dffpf) logic table definition
 // FUNCTION : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
 //            ASYNCHRONOUS SET AND CLEAR. CLR PRIORITY WHEN BOTH
 //            SET AND CLEAR ARE LOW ( Q OUTPUT UDP ).
 //            Enable active low.

 //----------------------------------------------------------------------
primitive Dffpf (Q, D, CLK, CLR, PRE, E, NOTIFIER_REG);
  output Q;
  input  NOTIFIER_REG;
  input  D, CLK, E, CLR, PRE;
  reg Q;

 table

//    D   CLK     CLR PRE  E  NOTIFIER_REG  :   Qt  :  Qt+1	
	     1   (10)    1   1    0      ?         :   ?   :   1;  // clocked data
	     0   (10)    1   1    0      ?         :   ?   :   0;  // clocked data
	     1   (10)    1   1    x      ?         :   1   :   1;  // clocked data
	     0   (10)    1   1    x      ?         :   0   :   0;
	     0   (10)    1   x    x      ?         :   1   :   1;
	     0   (10)    1   1    x      ?         :   1   :   x;
	     1   (10)    1   1    x      ?         :   0   :   x;
	     0   (10)    1   x    0      ?         :   1   :   1;
	     0   (10)    x   1    0      ?         :   ?   :   0;
	     1   (10)    1   ?    0      ?         :   ?   :   1;  // pessimism
	     1    ?      1   x    0      ?         :   1   :   1;  // pessimism
	     ?    ?      1   x    ?      ?         :   0   :   x;
	     0    1      1   x    0      ?         :   1   :   1;  // pessimism
	     0    x      1 (?x)   0      ?         :   1   :   1;  // pessimism
	     0    ?      1 (?x)   0      ?         :   1   :   1;  // baoxian
	     0    ?      x   1    ?      ?         :   0   :   0;
	     0    ?      x   0    ?      ?         :   ?   :   x;
	     0    ?      x   1    ?      ?         :   1   :   x;
	     x    1      1   x    0      ?         :   1   :   1;  // pessimism
	     x    x      1 (?x)   0      ?         :   1   :   1;  // pessimism
	     x    0      1   x    0      ?         :   1   :   1;  // pessimism
	     1    ?      1   x    x      ?         :   1   :   1;  // pessimism
	     0    1      1   x    x      ?         :   1   :   1;  // pessimism
	     0    x      1 (?x)   x      ?         :   1   :   1;  // pessimism
	     0    0      1 (?x)   x      ?         :   1   :   1;  // pessimism
	     x    1      1   x    x      ?         :   1   :   1;  // pessimism
	     x    ?      1   x    x      ?         :   1   :   1;  // pessimism
	     1    0      x   1    0      ?         :   0   :   0;  // pessimism
	     1    x    (?x)  1    0      ?         :   0   :   0;  // pessimism
	     1    1    (?x)  1    0      ?         :   0   :   0;  // pessimism
	     x    0      x   1    0      ?         :   0   :   0;  // pessimism
	     x    x    (?x)  1    0      ?         :   0   :   0;  // pessimism
	     x    1    (?x)  1    0      ?         :   0   :   0;  // pessimism
	     1    0      x   1    x      ?         :   0   :   0;  // pessimism
	     1    x    (?x)  1    x      ?         :   0   :   0;  // pessimism
	     1    1    (?x)  1    x      ?         :   0   :   0;  // pessimism
	     x    0      x   1    x      ?         :   0   :   0;  // pessimism
	     x    x    (?x)  1    x      ?         :   0   :   0;  // pessimism
	     x    1    (?x)  1    x      ?         :   0   :   0;  // pessimism
	     1   (1x)    1   1    0      ?         :   1   :   1;  // reducing pessimism
	     0   (1x)    1   1    0      ?         :   0   :   0;
	     1   (x0)    1   1    0      ?         :   1   :   1;
	     0   (x0)    1   1    0      ?         :   0   :   0;
	     1   (1x)    1   1    x      ?         :   1   :   1;  // reducing pessimism
	     0   (1x)    1   1    x      ?         :   0   :   0;
	     1   (x0)    1   1    x      ?         :   1   :   1;
	     0   (x0)    1   1    x      ?         :   0   :   0;
	     ?   ?       0   1    ?      ?         :   ?   :   0;  // asynchronous clear
	     ?   ?       1   0    ?      ?         :   ?   :   1;  // asynchronous set
	     ?  (?0)     1   1    1      ?         :   ?   :   -;  //no action for CE = 1
	     ?  (1x)     1   1    1      ?         :   ?   :   -;  //no action for CE = 1
	     ?   (?0)    x   1    1      ?         :   0   :   0;  // chip is not enabled pessimism with reset
	     ?   (1x)    x   1    1      ?         :   0   :   0;  // chip is not enabled pessimism with reset
	     ?    ?    (?x)  1    1      ?         :   0   :   0;  // chip is not enabled pessimism with reset
	     ?   (?0)    1   x    1      ?         :   1   :   1;  // chip is not enabled pessimism with reset
	     ?   (1x)    1   x    1      ?         :   1   :   1;  // chip is not enabled pessimism with reset
	     ?    ?      1  (?x)  1      ?         :   1   :   1;  // chip is not enabled pessimism with reset
	     ?   ?       ?   ?    *      ?         :   ?   :   -;
	     ?   (?1)    ?   ?    ?      ?         :   ?   :   -;  // ignore falling clock
	     ?   (0x)    ?   ?    ?      ?         :   ?   :   -;  // ignore falling clock
	     *    ?      ?   ?    ?      ?         :   ?   :   -;  // ignore data edges
	     ?   ?     (?1)  ?    ?      ?         :   ?   :   -;  // ignore the edges on
	     ?   ?       ?  (?1)  ?      ?         :   ?   :   -;  //       set and clear
	     ?   ?       0   0    ?      ?         :   ?   :   0; // CLR Priority (added 0n 11/12/97)
	     ?   ?       0   x    ?      ?         :   ?   :   0; // CLR Priority (added 0n 11/12/97)
	     ?   ?       ?   ?    ?      *         :   ?   :   x;
	endtable
 endprimitive

//--------------------------------------------------------------------
//-                    cell  UFPRB.v                                  -
//--------------------------------------------------------------------

primitive UFPRB (Q, D, CP, RB, NOTIFIER_REG);

    output Q;
    input  NOTIFIER_REG,
           D, CP, RB;
    reg    Q;

// FUNCTION : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
//            ASYNCHRONOUS CLEAR ( Q OUTPUT UDP ).

    table
    //  D   CP      RB     NOTIFIER_REG  :   Qt  :   Qt+1

        1   (01)    1         ?          :   ?   :   1;  // clocked data
        0   (01)    1         ?          :   ?   :   0;

        0   (01)    x         ?          :   ?   :   0;  // pessimism
        0    ?      x         ?          :   0   :   0;  // pessimism

        1    0      x         ?          :   0   :   0;  // pessimism
        1    x    (?x)        ?          :   0   :   0;  // pessimism
        1    1    (?x)        ?          :   0   :   0;  // pessimism
        x    0      x         ?          :   0   :   0;  // pessimism
        x    x    (?x)        ?          :   0   :   0;  // pessimism
        x    1    (?x)        ?          :   0   :   0;  // pessimism
        1   (x1)    1         ?          :   1   :   1;  // reducing pessimism
        0   (x1)    1         ?          :   0   :   0;
        1   (0x)    1         ?          :   1   :   1;
        0   (0x)    1         ?          :   0   :   0;
        ?   ?       0         ?          :   ?   :   0;  // asynchronous clear
        ?   (?0)    ?         ?          :   ?   :   -;  // ignore falling clock
        ?   (1x)    ?         ?          :   ?   :   -;  // ignore falling clock
        *    ?      ?         ?          :   ?   :   -;  // ignore the edges on data
        ?    ?    (?1)        ?          :   ?   :   -;  // ignore the edges on clear
        ?    ?      ?         *          :   ?   :   x;
    endtable
endprimitive

//--------------------------------------------------------------------
//-                    cell  UFNRB.v                                  -
//--------------------------------------------------------------------
primitive UFNRB (Q, D, CP, RB, NOTIFIER_REG);
    output Q;
    input  NOTIFIER_REG,
           D, CP, RB;
    reg    Q;
// FUNCTION : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
//            ASYNCHRONOUS CLEAR ( Q OUTPUT UDP ).
    table
    //  D   CP      RB     NOTIFIER_REG  :   Qt  :   Qt+1
        1   (10)    1         ?          :   ?   :   1;  // clocked data
        0   (10)    1         ?          :   ?   :   0;
        0   (10)    x         ?          :   ?   :   0;  // pessimism
        0    ?      x         ?          :   0   :   0;  // pessimism
        1    1      x         ?          :   0   :   0;  // pessimism
        1    x    (?x)        ?          :   0   :   0;  // pessimism
        1    0    (?x)        ?          :   0   :   0;  // pessimism
        x    1      x         ?          :   0   :   0;  // pessimism
        x    x    (?x)        ?          :   0   :   0;  // pessimism
        x    0    (?x)        ?          :   0   :   0;  // pessimism
        1   (1x)    1         ?          :   1   :   1;  // reducing pessimism
        0   (1x)    1         ?          :   0   :   0;
        1   (x0)    1         ?          :   1   :   1;
        0   (x0)    1         ?          :   0   :   0;
        ?   ?       0         ?          :   ?   :   0;  // asynchronous clear
        ?   (?1)    ?         ?          :   ?   :   -;  // ignore falling clock
        ?   (0x)    ?         ?          :   ?   :   -;  // ignore falling clock
        *    ?      ?         ?          :   ?   :   -;  // ignore the edges on data
        ?    ?    (?1)        ?          :   ?   :   -;  // ignore the edges on clear
        ?    ?      ?         *          :   ?   :   x;
    endtable
endprimitive

//------------------------------------------------------------------------
// primitive DL2C_UDP functional description
// FUNCTION : NEGATIVE LEVEL SENSITIVE D-TYPE LATCH WITH ACTIVE HIGH
//            ASYNCHRONOUS SET AND RESET.
//-------------------------------------------------------------------------

primitive DL2C_UDP (q, d, g, c, p, NOTIFIER_REG);

 output q;
 input  d,              // DATA
        g,              // CLOCK
        c,              // CLEAR ACTIVE HIGH
        p,              // SET ACTIVE HIGH
        NOTIFIER_REG;

 reg q;

    table
    //  D     G     C     P  NOTIFIER_REG  :   Qt  :   Qt+1
        ?     ?     1     ?     ?          :   ?   :   0;  // active low clear
        ?     ?     0     1     ?          :   ?   :   1;  // active high preset

        ?     1     0     0     ?          :   ?   :   -;  // latch
        0     0     0     0     ?          :   ?   :   0;  // transparent

        0     0     x     0     ?          :   ?   :   0;  // CLR==x
        ?     1     x     0     ?          :   0   :   0;  // CLR==x
        0     x     ?     0     ?          :   0   :   0;  // CLR,G==x

        1     x     0     ?     ?          :   1   :   1;  // PRE==x/?,G==x
        1     0     0     ?     ?          :   ?   :   1;  // PRE==x/?
        ?     1     0     x     ?          :   1   :   1;  // PRE==x
    endtable


endprimitive

//--------------------------------------------------------------------------
// primitive DLE3B_UDP
// FUNCTION : D LATCH WITH DUAL CLOCK INPUTS ACTIVE HIGH ASYNCHRONOUS PRESET.
//            TWO CLOCKS: E G
//-------------------------------------------------------------------------

primitive DLE3B_UDP (q, d, g, e, p, NOTIFIER_REG);

 output q;
 input  d,              // DATA
        g,              // CLOCK
        e,              // CLEAR ACTIVE HIGH
        p,              // SET ACTIVE HIGH
        NOTIFIER_REG;

 reg    q;

    table
    //  D     G     E     P  NOTIFIER_REG  :   Qt  :   Qt+1
        ?     ?     ?     1     ?          :   ?   :   1;  // active high preset

        ?     1     ?     0     ?          :   ?   :   -;  // latch
        ?     ?     1     0     ?          :   ?   :   -;  // latch

        1     0     0     0     ?          :   ?   :   1;  // transparent
        0     0     0     0     ?          :   ?   :   0;  // transparent

        1     x     ?     0     ?          :   1   :   1;  // o/p mux pessimism
        1     ?     x     0     ?          :   1   :   1;  // o/p mux pessimism
        0     x     ?     0     ?          :   0   :   0;  // o/p mux pessimism
        0     ?     x     0     ?          :   0   :   0;  // o/p mux pessimism

        1     0     0     x     ?          :   ?   :   1;  // PRE==x
        ?     1     ?     x     ?          :   1   :   1;  // PRE==x
        ?     ?     1     x     ?          :   1   :   1;  // PRE==x
        1     0     x     x     ?          :   1   :   1;  // PRE==x
        1     x     0     x     ?          :   1   :   1;  // PRE==x
        1     x     x     x     ?          :   1   :   1;  // PRE==x
    endtable

endprimitive

//--------------------------------------------------------------------------
// primitive DLE2B_UDP
// FUNCTION : D LATCH WITH DUAL CLOCK INPUTS ACTIVE HIGH ASYNCHRONOUS CLEAR.
//            TWO CLOCKS: E G
//-------------------------------------------------------------------------

primitive DLE2B_UDP (q, d, e, g, c, NOTIFIER_REG);

 output q;
 input  d,              // DATA
        e,              // CLOCK
        g,              // CLOCK
        c,              // CLEAR ACTIVE HIGH
        NOTIFIER_REG;

 reg    q;

    table
    //  D     E     G     C  NOTIFIER_REG  :   Qt  :   Qt+1
        ?     ?     ?     0     ?          :   ?   :   0;  // active low clear

        ?     ?     1     1     ?          :   ?   :   -;  // latch
        ?     1     ?     1     ?          :   ?   :   -;  // latch

        1     0     0     1     ?          :   ?   :   1;  // transparent
        0     0     0     1     ?          :   ?   :   0;  // transparent

        0     ?     ?     1     ?          :   0   :   0;  // o/p mux pessimism
        1     ?     ?     1     ?          :   1   :   1;  // o/p mux pessimism

        0     ?     ?     x     ?          :   0   :   0;  // CLR==x, o/p mux pessimism
        ?     ?     1     x     ?          :   0   :   0;  // PRE==x, o/p mux pessimism, latch
        ?     1     ?     x     ?          :   0   :   0;  // PRE==x, o/p mux pessimism, latch
        0     0     0     x     ?          :   ?   :   0;  // PRE==x, o/p mux pessimism
    endtable

endprimitive

//--------------------------------------------------------------------
//-                 primitive  JKFFF  -- falling edge                -
//--------------------------------------------------------------------

primitive JKFFF (Q, J, K, CP, RB, SB, NOTIFIER_REG);
    output Q;
    reg    Q; 
    input  NOTIFIER_REG,
           J,K,
            CP,                                  // Clock.
            RB,                                  // Clear input
            SB;                                  // Set input
// FUNCTION :NEGATIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW
//           ASYNCHRONOUS CLEAR AND  SET
//           OUTPUT GOES TO X WHEN BOTH CLEAR AND SET ARE ACTIVE
    table
      // J   K   CP  RB   SB       NOTIFIER_REG  : Qtn : Qtn+1
         0   1  (10) 1    1           ?          :  ?  :   - ;    // Output retains the
         0   0  (10) 1    1           ?          :  ?  :   0 ;    // Clocked J and K.
         0   0  (10) x    1           ?          :  ?  :   0 ;    // pessimism
         ?   ?   ?   x    1           ?          :  0  :   0 ;    // pessimism
         1   1  (10) 1    1           ?          :  ?  :   1 ;
         1   1  (10) 1    x           ?          :  ?  :   1 ;    // pessimism
         ?   ?   ?   1    x           ?          :  1  :   1 ;    // pessimis
         1   0  (10) 1    1           ?          :  0  :   1 ;    // Clocked toggle.
         1   0  (10) 1    1           ?          :  1  :   0 ;
         ?   0  (10) x    1           ?          :  1  :   0 ;    //pessimism
         1   ?  (10) 1    x           ?          :  0  :   1 ;
         0   1  (1x) 1    1           ?          :  ?  :   - ;    //possible clocked JK
         0   0  (1x) 1    1           ?          :  0  :   0 ;
         1   1  (1x) 1    1           ?          :  1  :   1 ;
         0   1  (x0) 1    1           ?          :  ?  :   - ;
         0   0  (x0) 1    1           ?          :  0  :   0 ;
         1   1  (x0) 1    1           ?          :  1  :   1 ;
         *   ?   ?   1    1           ?          :  ?  :   - ;    // Insensitive to
         ?   *   ?   1    1           ?          :  ?  :   - ;    // transitions on J and K
         ?   ?   ?   0    1           ?          :  ?  :   0 ;    // Clear
         ?   ?   ?   1    0           ?          :  ?  :   1 ;    // Set.
         ?   ?   ?   0    0           ?          :  ?  :   x ;    // ILLEGAL
         x   1   f   1    1           ?          :  1  :   1 ;
         x   0   f   1    1           ?          :  1  :   0 ;
         0   x   f   1    1           ?          :  0  :   0 ;
         1   x   f   1    1           ?          :  0  :   1 ;
         x   1 (1x)  1    1           ?          :  1  :   1 ;    //possible clocked with
         0   x (1x)  1    1           ?          :  0  :   0 ;    //possible J & K
         x   1 (x0)  1    1           ?          :  1  :   1 ;
         0   x (x0)  1    1           ?          :  0  :   0 ;
         ?   ? (?1)  ?    ?           ?          :  ?  :   - ;
         ?   ? (0x)  ?    ?           ?          :  ?  :   - ;
         ?   ?   ? (?1)   1           ?          :  ?  :   - ;    //ignore changes on set and
         ?   ?   ?   1  (?1)          ?          :  ?  :   - ;    //reset.
         ?   ?   ?   ?    ?           *          :  ?  :   x ;
    endtable
endprimitive

//--------------------------------------------------------------------
//-                   primitive  JKFFR                                -
//--------------------------------------------------------------------
primitive JKFFR (Q, J, K, CP, RB, SB, NOTIFIER_REG);
    output Q;
    reg    Q; 
    input  NOTIFIER_REG,
           J,K,
           CP,                                  // Clock.
           RB,                                  // Clear input
           SB;                                  // Set input
// FUNCTION :POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW
//           ASYNCHRONOUS CLEAR AND  SET
//           OUTPUT GOES TO x WHEN BOTH CLEAR AND SET ARE ACTIVE
    table
      // J   K  CP  RB   SB        NOTIFIER_REG  : Qtn : Qtn+1
         0   1  (01) 1    1           ?          :  ?  :   - ;    // Output retains the
         0   0  (01) 1    1           ?          :  ?  :   0 ;    // Clocked J and K.
         0   0  (01) x    1           ?          :  ?  :   0 ;    // pessimism
         ?   ?   ?   x    1           ?          :  0  :   0 ;    // pessimism
         1   1  (01) 1    1           ?          :  ?  :   1 ;
         1   1  (01) 1    x           ?          :  ?  :   1 ;    // pessimism
         ?   ?   ?   1    x           ?          :  1  :   1 ;    // pessimism
         1   0  (01) 1    1           ?          :  0  :   1 ;    // Clocked toggle.
         1   0  (01) 1    1           ?          :  1  :   0 ;
         ?   0  (01) x    1           ?          :  1  :   0 ;     //pessimism
         1   ?  (01) 1    x           ?          :  0  :   1 ;
         0   1  (x1) 1    1           ?          :  ?  :   - ;   //possible clocked JK
         0   0  (x1) 1    1           ?          :  0  :   0 ;
         1   1  (x1) 1    1           ?          :  1  :   1 ;
         0   1  (0x) 1    1           ?          :  ?  :   - ;
         0   0  (0x) 1    1           ?          :  0  :   0 ;
         1   1  (0x) 1    1           ?          :  1  :   1 ;
         *   ?   ?   1    1           ?          :  ?  :   - ;    // Insensitive to
         ?   *   ?   1    1           ?          :  ?  :   - ;    // transitions on J and K
         ?   ?   ?   0    1           ?          :  ?  :   0 ;    // Clear
         ?   ?   ?   1    0           ?          :  ?  :   1 ;    // Set.
         ?   ?   ?   0    0           ?          :  ?  :   x ;    // ILLEGAL
         x   1   r   1    1           ?          :  1  :   1 ;
         x   0   r   1    1           ?          :  1  :   0 ;
         0   x   r   1    1           ?          :  0  :   0 ;
         1   x   r   1    1           ?          :  0  :   1 ;
         x   1 (x1)  1    1           ?          :  1  :   1 ;        //possible clocked with
         0   x (x1)  1    1           ?          :  0  :   0 ;        //possible J & K
         x   1 (0x)  1    1           ?          :  1  :   1 ;
         0   x (0x)  1    1           ?          :  0  :   0 ;
         ?   ? (?0)  1    1           ?          :  ?  :   - ;    //ignore falling clock.
         ?   ? (1x)  1    1           ?          :  ?  :   - ;
         ?   ?   ? (?1)   1           ?          :  ?  :   - ;    //ignore changes on set and
         ?   ?   ?   1  (?1)          ?          :  ?  :   - ;    //reset.
         ?   ?   ?   ?    ?           *          :  ?  :   x ;
    endtable
endprimitive
 // --------------------------------------------------------------------
 // 2-1 MUX  primitive   
 // FUNCTION : when select signal S= 1, A will be selected, S= 0, B will 
 //            be selected; when S=X, if A=B, A will be selected, if A!=B,
 //            X will be the output!
 // --------------------------------------------------------------------
primitive UDP_MUX2 (Q, A, B, SL);
output Q;
input A, B, SL;

// FUNCTION :  TWO TO ONE MULTIPLEXER

    table
    //  A   B   SL  :   Q
        0   0   ?   :   0 ;
        1   1   ?   :   1 ;

        0   ?   1   :   0 ;
        1   ?   1   :   1 ;

        ?   0   0   :   0 ;
        ?   1   0   :   1 ;

    endtable
endprimitive

primitive UDPN_MUX2 (Q, A, B, SL);
output Q;
input A, B, SL;

// FUNCTION :  TWO TO ONE MULTIPLEXER

    table
    //  A   B   SL  :   Q
        0   0   ?   :   1 ;
        1   1   ?   :   0 ;

        0   ?   1   :   1 ;
        1   ?   1   :   0 ;

        ?   0   0   :   1 ;
        ?   1   0   :   0 ;

    endtable
endprimitive


//---------------  END OF VERILOG PRIMITIVE SECTION --------------------

primitive CMA9_primitive (Y, D0,DB, D3,S01,S11);
output Y;
input D0,DB, D3,S01,S11;


	table
	// D0   DB   D3   S01  S11 :       Y
	   ?    0    ?    0    ?  :       1;
	   ?    1    ?    ?    1  :       0;
	   ?    0    0    1    ?  :       0;
	   1    1    ?    ?    0  :       1;
	   1    ?    1    ?    0  :       1;
	   ?    0    1    ?    ?  :       1;
	   0    1    ?    ?    ?  :       0;
	   0    ?    0    1    ?  :       0;
	   1    ?    ?    0    0  :       1;
	   ?    ?    0    1    1  :       0;

	endtable
endprimitive

primitive CMAF_primitive (Y, D0, D2,  D3, DB, S01, S11);
output Y;
input D0, D2,  D3, DB, S01, S11;


	table
	// D0   D2   D3   DB   S01  S11       Y
	   0    0    0     ?    ?    ? :    0;
	   1    1    1     ?    ?    ? :    1;
	   0    0    ?     ?    0    0 :    0;
	   1    1    ?     ?    0    0 :    1;
	   0    0    ?     1    ?    ? :    0;
	   1    1    ?     1    ?    ? :    1;
	   0    0    ?     ?    0    ? :    0;
	   1    1    ?     ?    0    ? :    1;
	   ?    0    0     ?    1    1 :    0;
	   ?    1    1     ?    1    1 :    1;
	   ?    0    0     0    ?    ? :    0;
	   ?    1    1     0    ?    ? :    1;
	   ?    0    0     ?    ?    1 :    0;
	   ?    1    1     ?    ?    1 :    1;
	   0    ?    0     ?    1    0 :    0;
	   1    ?    1     ?    1    0 :    1;
	   ?    0    ?     0    0    ? :    0;
	   ?    1    ?     0    0    ? :    1;
	   ?    0    ?     1    ?    1 :    0;
	   ?    1    ?     1    ?    1 :    1;
	   ?    0    ?     ?    0    1 :    0;
	   ?    1    ?     ?    0    1 :    1;
	   ?    ?    0     0    1    ? :    0;
	   ?    ?    1     0    1    ? :    1;
	   0    ?    ?     1    ?    0 :    0;
	   1    ?    ?     1    ?    0 :     1;

	endtable
endprimitive

primitive CMB7_primitive (Y, D0, D1, D2, DB, S00, S01, S11);
output Y;
input D0, D1, D2, DB, S00, S01, S11;


   table
	//D0   D1   D2   DB   S00  S01  S11          Y
	  0    0    0    1    ?    ?    ?  :       0;
	  ?    ?    1    0    ?    ?    ?  :      1;
	  ?    0    ?    1    1    1    0  :      0;
	  ?    1    ?    ?    1    1    0  :      1;
	  0    ?    ?    1    0    ?    0  :      0;
	  0    ?    ?    1    ?    0    0  :      0;
	  1    ?    ?    1    0    ?    0  :      1;
	  1    ?    ?    1    ?    0    0  :      1;
	  ?    ?    ?    1    1    1    1  :      0;
	  ?    ?    ?    0    1    1    ?  :      1;
	  ?    ?    0    0    0    ?    ?  :      0;
	  ?    ?    0    0    ?    0    ?  :      0;
	  ?    ?    0    ?    0    ?    1  :      0;
	  ?    ?    0    ?    ?    0    1  :      0;
	  0    ?    0    ?    0    ?    ?  :      0;
	  0    ?    0    ?    ?    0    ?  :      0;
	  1    ?    1    ?    0    ?    ?  :      1;
	  1    ?    1    ?    ?    0    ?  :      1;
	  ?    ?    1    ?    0    ?    1  :      1;
	  ?    ?    1    ?    ?    0    1  :      1;
	  ?    0    ?    1    1    1    ?  :      0;
	  0    0    ?    1    ?    ?    0  :      0;
	  1    1    ?    1    ?    ?    0  :      1;
	  ?    ?    0    1    ?    ?    1  :      0;
	  1    1    1    ?    ?    ?    0  :      1;

	endtable
endprimitive

primitive CMBB_primitive (Y, D0,D1,DB,D3,S00,S01,S11);
output Y;
input D0,D1,DB,D3,S00,S01,S11;


	table
// D0   D1   DB   D3   S00  S01  S11          Y
	0    0    1    0    ?    ?    ? :        0;
	?    ?    0    1    ?    ?    ? :       1;
	?    ?    0    ?    ?    0    ? :       1;
	?    ?    1    ?    ?    0    1 :       0;
	?    ?    0    ?    0    ?    ? :       1;
	?    ?    1    ?    0    ?    1 :       0;
	0    ?    1    ?    ?    0    0 :       0;
	1    ?    ?    ?    ?    0    0 :       1;
	0    ?    1    ?    0    ?    0 :       0;
	1    ?    ?    ?    0    ?    0 :       1;
	?    0    1    ?    1    1    0 :       0;
	?    1    1    ?    1    1    0 :       1;
	?    ?    ?    0    1    1    1 :       0;
	?    ?    ?    1    1    1    1 :       1;
	?    ?    0    0    1    1    ? :       0;
	?    ?    1    0    ?    ?    1 :       0;
	?    0    ?    0    1    1    ? :       0;
	?    1    ?    1    1    1    ? :       1;
	0    ?    1    ?    0    ?    ? :       0;
	0    0    1    ?    ?    ?    0 :       0;
	1    1    1    ?    ?    ?    0 :       1;
	0    ?    1    ?    ?    0    ? :       0;
	1    1    ?    1    ?    ?    0 :       1;

	endtable
endprimitive

primitive CMEA_primitive (Y, DB,D1,D3,S01,S10,S11);
output Y;
input DB,D1,D3,S01,S10,S11;


	table
// DB   D1   D3   S01  S10  S11          Y
	1     ?    ?    ?   ?    ? :       0;
	0     1    1    ?   ?    ? :       1;
	0     0    ?    1   0    0 :       0;
	0     1    ?    ?   0    0 :       1;
	0     ?    0    1   1    ? :       0;
	0     ?    0    1   ?    1 :       0;
	0     ?    ?    0   ?    ? :       1;
	?     0    0    1   ?    ? :       0;
	0     ?    1    ?   1    ? :       1;
	0     ?    1    ?   ?    1 :       1;

   endtable
endprimitive

primitive CMEB_primitive (Y,D0,D1,DB,D3,S01,S10,S11);
output Y;
input D0,D1,DB,D3,S01,S10,S11;


   table
	// D0   D1   DB   D3   S01  S10  S11          Y
	0   0   1   0   ?   ?   ? :        0;
	1   1   0   1   ?   ?   ? :       1;
	0   ?   ?   ?   0   0   0 :       0;
	1   ?   ?   ?   0   0   0 :       1;
	0   ?   1   ?   ?   0   0 :       0;
	1   ?   1   ?   ?   0   0 :       1;
	?   ?   0   1   1   1   ? :       1;
	?   ?   0   1   1   ?   1 :       1;
	?   0   0   ?   1   0   0 :       0;
	?   1   0   ?   1   0   0 :       1;
	?   ?   ?   0   1   1   ? :       0;
	?   ?   ?   0   1   ?   1 :       0;
	?   ?   1   ?   ?   1   ? :       0;
	?   ?   1   ?   ?   ?   1 :       0;
	?   ?   0   ?   0   1   ? :       1;
	?   0   0   0   1   ?   ? :       0;
	?   1   0   1   1   ?   ? :       1;
	0   0   ?   ?   ?   0   0 :       0;
	1   1   ?   ?   ?   0   0 :       1;
	0   ?   1   ?   ?   ?   ? :       0;
	1   ?   0   ?   0   ?   ? :       1;
	?   ?   0   1   ?   1   ? :       1;
	?   ?   0   1   ?   ?   1 :       1;
	?   ?   0   ?   0   ?   1 :       1;
	0   0   ?   0   1   ?   ? :       0;

	endtable
endprimitive

primitive CMEE_primitive (Y,DB, D1, D2, D3, S01,S10, S11);
output Y;
input DB, D1, D2, D3, S01,S10, S11;


   table
	//DB   D1   D2   D3   S01  S10  S11          Y
	1 0 0 0 ? ? ? :       0;
	0 1 1 1 ? ? ? :       1;
	? 0 ? ? 1 0 0 :       0;
	0 1 ? ? 1 0 0 :       1;
	0 ? ? 0 1 1 ? :       0;
	0 ? ? 1 1 1 ? :       1;
	0 ? ? 0 1 ? 1 :       0;
	0 ? ? 1 1 ? 1 :       1;
	1 ? ? ? ? 0 0 :       0;
	0 ? ? ? 0 0 0 :       1;
	? ? 0 ? 0 ? 1 :       0;
	? ? 1 ? 0 ? 1 :       1;
	? ? 0 ? 0 1 ? :       0;
	? ? 1 ? 0 1 ? :       1;
	1 ? 0 ? ? ? 1 :       0;
	1 ? 1 ? ? ? 1 :       1;
	1 ? 0 ? ? 1 ? :       0;
	1 ? 1 ? ? 1 ? :       1;
	1 ? 0 ? ? ? ? :       0;
	0 ? 1 ? 0 ? ? :       1;
	? ? 0 0 ? 1 ? :       0;
	? ? 1 1 ? 1 ? :       1;
	? ? 0 0 ? ? 1 :       0;
	0 0 ? 0 1 ? ? :       0;
	0 1 ? 1 1 ? ? :       1;
	? ? 1 1 ? ? 1 :       1;
	0 1 ? ? ? 0 0 :       1;
	? 0 0 0 1 ? ? :       0;

   endtable
endprimitive




/*--------------------------------------------------------------------
 CELL NAME : AND2
 CELL TYPE : comb
 CELL LOGIC : Y = A & B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND2(Y,A,B);
 input A,B;
 output Y;

 and      U2(Y, A, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND2FT
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND2FT(Y,A,B);
 input A,B;
 output Y;

 not	INV_0(A_, A);
 and      U5(Y, A_, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND3
 CELL TYPE : comb
 CELL LOGIC : Y = A & B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 and      U9(NET_0_0, A, B);
 and      U10(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND3FFT
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND3FFT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_1(A_, A);
 not	INV_2(B_, B);
 and      U14(NET_0_0, A_, B_);
 and      U15(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND3FTT
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND3FTT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_3(A_, A);
 and      U19(NET_0_0, A_, B);
 and      U20(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO21
 CELL TYPE : comb
 CELL LOGIC : Y = (A & B) + (C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO21(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 and      U24(NET_0_0, A, B);
 or       U25(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO21FTF
 CELL TYPE : comb
 CELL LOGIC : Y =!A & B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO21FTF(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_4(A_, A);
 not	INV_5(C_, C);
 and      U29(NET_0_0, A_, B);
 or       U30(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO21FTT
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO21FTT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_6(A_, A);
 and      U34(NET_0_0, A_, B);
 or       U35(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO21TTF
 CELL TYPE : comb
 CELL LOGIC : Y = A & B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO21TTF(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_7(C_, C);
 and      U39(NET_0_0, A, B);
 or       U40(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI21
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & !C) + (!B & !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI21(Y,A,C,B);
 input A,C,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_8(A_, A);
 not	INV_9(C_, C);
 not	INV_10(B_, B);
 and      U44(NET_0_0, A_, C_);
 or       U45(Y, NET_0_0, NET_0_1);
 and      U47(NET_0_1, B_, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI21FTF
 CELL TYPE : comb
 CELL LOGIC : Y = (A & C) + (!B & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI21FTF(Y,A,C,B);
 input A,C,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_11(B_, B);
 and      U51(NET_0_0, A, C);
 or       U52(Y, NET_0_0, NET_0_1);
 and      U54(NET_0_1, B_, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI21FTT
 CELL TYPE : comb
 CELL LOGIC : Y = (A & !C) + (!B & !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI21FTT(Y,A,C,B);
 input A,C,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_12(C_, C);
 not	INV_13(B_, B);
 and      U58(NET_0_0, A, C_);
 or       U59(Y, NET_0_0, NET_0_1);
 and      U61(NET_0_1, B_, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI21TTF
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & C) + (!B & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI21TTF(Y,A,C,B);
 input A,C,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_14(A_, A);
 not	INV_15(B_, B);
 and      U65(NET_0_0, A_, C);
 or       U66(Y, NET_0_0, NET_0_1);
 and      U68(NET_0_1, B_, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BFR
 CELL TYPE : comb
 CELL LOGIC : Y = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BFR(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BUBBLE
 CELL TYPE : comb
 CELL LOGIC : Y = !A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BUBBLE(Y,A);
 input A;
 output Y;

 not	INV_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : DMUX
 CELL TYPE : comb
 CELL LOGIC : Y = A & !S + B & S
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DMUX(Y,A,S,B);
 input A,S,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_16(S_, S);
 UDP_MUX2   U71(Y, A, B, S_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(S => Y ) = ( tpdLH_S_to_Y, tpdHL_S_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GL25
 CELL TYPE : comb
 CELL LOGIC : GL = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GL25(GL,PAD);
 input PAD;
 output GL;

 buf	BUF_U_00(GL,PAD);

       specify

		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GL25LP
 CELL TYPE : comb
 CELL LOGIC : GL = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GL25LP(GL,PAD);
 input PAD;
 output GL;

 buf	BUF_U_00(GL,PAD);

       specify

		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GL25LPS
 CELL TYPE : comb
 CELL LOGIC : GL = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GL25LPS(GL,PAD);
 input PAD;
 output GL;

 buf	BUF_U_00(GL,PAD);

       specify

		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GL25LPU
 CELL TYPE : comb
 CELL LOGIC : GL#UP = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GL25LPU(GL,PAD);
 input PAD;
 output GL;

 pullup	UP(PAD);
 buf	BUF_U_00(GL,PAD);

       specify

		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GL25LPUS
 CELL TYPE : comb
 CELL LOGIC : GL#UP = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GL25LPUS(GL,PAD);
 input PAD;
 output GL;

 pullup	UP(PAD);
 buf	BUF_U_00(GL,PAD);

       specify

		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GL25S
 CELL TYPE : comb
 CELL LOGIC : GL = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GL25S(GL,PAD);
 input PAD;
 output GL;

 buf	BUF_U_00(GL,PAD);

       specify

		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GL25U
 CELL TYPE : comb
 CELL LOGIC : GL#UP = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GL25U(GL,PAD);
 input PAD;
 output GL;

 pullup	UP(PAD);
 buf	BUF_U_00(GL,PAD);

       specify

		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GL25US
 CELL TYPE : comb
 CELL LOGIC : GL#UP = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GL25US(GL,PAD);
 input PAD;
 output GL;

 pullup	UP(PAD);
 buf	BUF_U_00(GL,PAD);

       specify

		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GL33
 CELL TYPE : comb
 CELL LOGIC : GL = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GL33(GL,PAD);
 input PAD;
 output GL;

 buf	BUF_U_00(GL,PAD);

       specify

		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GL33S
 CELL TYPE : comb
 CELL LOGIC : GL = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GL33S(GL,PAD);
 input PAD;
 output GL;

 buf	BUF_U_00(GL,PAD);

       specify

		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GL33U
 CELL TYPE : comb
 CELL LOGIC : GL#UP = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GL33U(GL,PAD);
 input PAD;
 output GL;

 pullup	UP(PAD);
 buf	BUF_U_00(GL,PAD);

       specify

		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GL33US
 CELL TYPE : comb
 CELL LOGIC : GL#UP = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GL33US(GL,PAD);
 input PAD;
 output GL;

 pullup	UP(PAD);
 buf	BUF_U_00(GL,PAD);

       specify

		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLINT
 CELL TYPE : comb
 CELL LOGIC : GL = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLINT(GL,A);
 input A;
 output GL;

 buf	BUF_U_00(GL,A);

       specify

		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GND
 CELL TYPE : comb
 CELL LOGIC : Y = 0
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GND(Y);
 output Y;

 supply0	Y;

       specify

		specparam MacroType = "comb";

		//pin to pin path delay 

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IB25
 CELL TYPE : comb
 CELL LOGIC : Y = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IB25(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IB25LP
 CELL TYPE : comb
 CELL LOGIC : Y = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IB25LP(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IB25LPS
 CELL TYPE : comb
 CELL LOGIC : Y = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IB25LPS(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IB25LPU
 CELL TYPE : comb
 CELL LOGIC : Y#UP = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IB25LPU(Y,PAD);
 input PAD;
 output Y;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IB25LPUS
 CELL TYPE : comb
 CELL LOGIC : Y#UP = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IB25LPUS(Y,PAD);
 input PAD;
 output Y;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IB25S
 CELL TYPE : comb
 CELL LOGIC : Y = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IB25S(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IB25U
 CELL TYPE : comb
 CELL LOGIC : Y#up = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IB25U(Y,PAD);
 input PAD;
 output Y;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IB25US
 CELL TYPE : comb
 CELL LOGIC : Y#UP = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IB25US(Y,PAD);
 input PAD;
 output Y;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IB33
 CELL TYPE : comb
 CELL LOGIC : Y = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IB33(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IB33S
 CELL TYPE : comb
 CELL LOGIC : Y = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IB33S(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IB33U
 CELL TYPE : comb
 CELL LOGIC : Y#UP = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IB33U(Y,PAD);
 input PAD;
 output Y;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IB33US
 CELL TYPE : comb
 CELL LOGIC : Y#UP = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IB33US(Y,PAD);
 input PAD;
 output Y;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INV
 CELL TYPE : comb
 CELL LOGIC : Y = !A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INV(Y,A);
 input A;
 output Y;

 not	INV_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LD
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =EN, D=D ];
-----------------------------------------------------------------*/

module LD(EN, Q,D);
 input D,EN;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLK(EN_, EN);
 DL2C_UDP DL_U0(Q, D, EN_, GND, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	buf U_c1 (Enable2, EN);
	buf U_c3 (Enable4, EN);
	buf U_c5 (Enable6, EN);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="APA";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(EN )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	(posedge EN => (Q+:D))=(tpdLH_EN_to_Q, tpdHL_EN_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge EN, 0.0, NOTIFY_REG);
	$hold(negedge EN, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge EN, 0.0, NOTIFY_REG);
	$hold(negedge EN, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge EN, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDB
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =EN, CLR=CLR, PRE=SET, D=D ];
-----------------------------------------------------------------*/

module LDB(SET, CLR, EN, Q,D);
 input D,SET,CLR,EN;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(SET_, SET);
 not INV_CLR(CLR_, CLR);
 not INV_CLK(EN_, EN);
 DL2C_UDP DL_U0(Q, D, EN_, CLR, SET, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I1 (_SET, SET);
	not U_I2 (_CLR, CLR);
	and U_c0 (Enable1, _CLR, _SET);
	and U_c1 (Enable2, EN, _CLR, _SET);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, EN, _CLR);
	buf U_c4 (Enable5, _SET);
	and U_c5 (Enable6, EN, _SET);
	and U_c6 (Enable7, _CLR, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="APA";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$SET = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_SET_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_SET_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(EN && !CLR && !SET )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(posedge EN => (Q+:D))=(tpdLH_EN_to_Q, tpdHL_EN_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	if(!CLR)
	(posedge SET => (Q +: 1'b1)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);
       if(EN && !CLR )
	(negedge SET => (Q+:D)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge SET &&& _CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge SET, negedge EN &&&  Enable3, 0.0, NOTIFY_REG);
	$hold (negedge EN &&& Enable3 , negedge SET, 0.0, NOTIFY_REG);
	$recovery (negedge CLR, negedge EN &&& Enable5, 0.0, NOTIFY_REG);
	$hold (negedge EN &&& Enable5, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDBI
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QBAR, CLK =EN, CLR=CLR, PRE=SET, D=D ];
-----------------------------------------------------------------*/

module LDBI(SET, CLR, EN, QBAR,D);
 input D,SET,CLR,EN;
 output QBAR;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(SET_, SET);
 not INV_CLR(CLR_, CLR);
 not INV_CLK(EN_, EN);
 DL2C_UDP DL_U0(QBAR_, D, EN_, CLR, SET, NOTIFY_REG);
  not INV_Q(QBAR, QBAR_);

// some temp signals created for timing checking sections

	not U_I1 (_SET, SET);
	not U_I2 (_CLR, CLR);
	and U_c0 (Enable1, _CLR, _SET);
	and U_c1 (Enable2, EN, _CLR, _SET);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, EN, _CLR);
	buf U_c4 (Enable5, _SET);
	and U_c5 (Enable6, EN, _SET);
	and U_c6 (Enable7, _CLR, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="APA";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$SET = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QBAR = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_SET_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_SET_to_QBAR = (0.1:0.1:0.1);

        //check timing delay for output



	if(EN && !CLR && !SET )
        (D => QBAR) = (tpdLH_D_to_QBAR, tpdHL_D_to_QBAR);

	if(Enable1)
	(posedge EN => (QBAR+:D))=(tpdLH_EN_to_QBAR, tpdHL_EN_to_QBAR);
	(posedge CLR => (QBAR +: 1'b0)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);
	(negedge CLR => (QBAR+:D)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);
	if(!CLR)
	(posedge SET => (QBAR +: 1'b1)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);
       if(EN && !CLR )
	(negedge SET => (QBAR+:D)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge SET &&& _CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge SET, negedge EN &&&  Enable3, 0.0, NOTIFY_REG);
	$hold (negedge EN &&& Enable3 , negedge SET, 0.0, NOTIFY_REG);
	$recovery (negedge CLR, negedge EN &&& Enable5, 0.0, NOTIFY_REG);
	$hold (negedge EN &&& Enable5, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDC
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =EN, CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module LDC(CLR, EN, Q,D);
 input D,CLR,EN;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 not INV_CLK(EN_, EN);
 DL2C_UDP DL_U0(Q, D, EN_, CLR, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,_CLR);
	and U_c1 (Enable2, EN,_CLR);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, EN, _CLR);
	buf U_c5 (Enable6, EN);
	buf U_c6 (Enable7, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="APA";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(EN && !CLR )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(posedge EN => (Q+:D))=(tpdLH_EN_to_Q, tpdHL_EN_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge CLR, negedge EN, 0.0, NOTIFY_REG);
	$hold (negedge EN, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDCI
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QBAR, CLK =EN, CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module LDCI(CLR, EN, QBAR,D);
 input D,CLR,EN;
 output QBAR;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 not INV_CLK(EN_, EN);
 DL2C_UDP DL_U0(QBAR_, D, EN_, CLR, GND, NOTIFY_REG);
  not INV_Q(QBAR, QBAR_);

// some temp signals created for timing checking sections

	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,_CLR);
	and U_c1 (Enable2, EN,_CLR);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, EN, _CLR);
	buf U_c5 (Enable6, EN);
	buf U_c6 (Enable7, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="APA";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QBAR = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_QBAR = (0.1:0.1:0.1);

        //check timing delay for output



	if(EN && !CLR )
        (D => QBAR) = (tpdLH_D_to_QBAR, tpdHL_D_to_QBAR);

	if(Enable1)
	(posedge EN => (QBAR+:D))=(tpdLH_EN_to_QBAR, tpdHL_EN_to_QBAR);
	(posedge CLR => (QBAR +: 1'b0)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);
	(negedge CLR => (QBAR+:D)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge CLR, negedge EN, 0.0, NOTIFY_REG);
	$hold (negedge EN, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDI
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QBAR, CLK =EN, D=D ];
-----------------------------------------------------------------*/

module LDI(EN, QBAR,D);
 input D,EN;
 output QBAR;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLK(EN_, EN);
 DL2C_UDP DL_U0(QBAR_, D, EN_, GND, GND, NOTIFY_REG);
  not INV_Q(QBAR, QBAR_);

// some temp signals created for timing checking sections

	buf U_c1 (Enable2, EN);
	buf U_c3 (Enable4, EN);
	buf U_c5 (Enable6, EN);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="APA";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QBAR = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_QBAR = (0.1:0.1:0.1);

        //check timing delay for output



	if(EN )
        (D => QBAR) = (tpdLH_D_to_QBAR, tpdHL_D_to_QBAR);

	(posedge EN => (QBAR+:D))=(tpdLH_EN_to_QBAR, tpdHL_EN_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge EN, 0.0, NOTIFY_REG);
	$hold(negedge EN, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge EN, 0.0, NOTIFY_REG);
	$hold(negedge EN, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge EN, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDL
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=EN, D=D ];
-----------------------------------------------------------------*/

module LDL(EN, Q,D);
 input D,EN;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 DL2C_UDP DL_U0(Q, D, EN, GND, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_EN, EN);
	buf U_c1 (Enable2, _EN);
	buf U_c3 (Enable4, _EN);
	buf U_c5 (Enable6, _EN);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="APA";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!EN )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	(negedge EN => (Q+:D))=(tpdLH_EN_to_Q, tpdHL_EN_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge EN, 0.0, NOTIFY_REG);
	$hold(posedge EN, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge EN, 0.0, NOTIFY_REG);
	$hold(posedge EN, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge EN, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDLB
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=EN, CLR=CLR, PRE=SET, D=D ];
-----------------------------------------------------------------*/

module LDLB(SET, CLR, EN, Q,D);
 input D,SET,CLR,EN;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(SET_, SET);
 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(Q, D, EN, CLR, SET, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_EN, EN);
	not U_I1 (_SET, SET);
	not U_I2 (_CLR, CLR);
	and U_c0 (Enable1, _CLR, _SET);
	and U_c1 (Enable2, _EN, _CLR, _SET);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, _EN, _CLR);
	buf U_c4 (Enable5, _SET);
	and U_c5 (Enable6, _EN, _SET);
	and U_c6 (Enable7, _CLR, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="APA";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$SET = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_SET_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_SET_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!EN && !CLR && !SET )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(negedge EN => (Q+:D))=(tpdLH_EN_to_Q, tpdHL_EN_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	if(!CLR)
	(posedge SET => (Q +: 1'b1)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);
       if(!EN && !CLR )
	(negedge SET => (Q+:D)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge SET &&& _CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge SET, posedge EN &&&  Enable3, 0.0, NOTIFY_REG);
	$hold (posedge EN &&& Enable3 , negedge SET, 0.0, NOTIFY_REG);
	$recovery (negedge CLR, posedge EN &&& Enable5, 0.0, NOTIFY_REG);
	$hold (posedge EN &&& Enable5, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDLBI
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QBAR, _CLK=EN, CLR=CLR, PRE=SET, D=D ];
-----------------------------------------------------------------*/

module LDLBI(SET, CLR, EN, QBAR,D);
 input D,SET,CLR,EN;
 output QBAR;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(SET_, SET);
 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(QBAR_, D, EN, CLR, SET, NOTIFY_REG);
  not INV_Q(QBAR, QBAR_);

// some temp signals created for timing checking sections

	not U_I0 (_EN, EN);
	not U_I1 (_SET, SET);
	not U_I2 (_CLR, CLR);
	and U_c0 (Enable1, _CLR, _SET);
	and U_c1 (Enable2, _EN, _CLR, _SET);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, _EN, _CLR);
	buf U_c4 (Enable5, _SET);
	and U_c5 (Enable6, _EN, _SET);
	and U_c6 (Enable7, _CLR, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="APA";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$SET = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QBAR = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_SET_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_SET_to_QBAR = (0.1:0.1:0.1);

        //check timing delay for output



	if(!EN && !CLR && !SET )
        (D => QBAR) = (tpdLH_D_to_QBAR, tpdHL_D_to_QBAR);

	if(Enable1)
	(negedge EN => (QBAR+:D))=(tpdLH_EN_to_QBAR, tpdHL_EN_to_QBAR);
	(posedge CLR => (QBAR +: 1'b0)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);
	(negedge CLR => (QBAR+:D)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);
	if(!CLR)
	(posedge SET => (QBAR +: 1'b1)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);
       if(!EN && !CLR )
	(negedge SET => (QBAR+:D)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge SET &&& _CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge SET, posedge EN &&&  Enable3, 0.0, NOTIFY_REG);
	$hold (posedge EN &&& Enable3 , negedge SET, 0.0, NOTIFY_REG);
	$recovery (negedge CLR, posedge EN &&& Enable5, 0.0, NOTIFY_REG);
	$hold (posedge EN &&& Enable5, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDLC
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=EN, CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module LDLC(CLR, EN, Q,D);
 input D,CLR,EN;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(Q, D, EN, CLR, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_EN, EN);
	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,_CLR);
	and U_c1 (Enable2, _EN, _CLR);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, _EN, _CLR);
	buf U_c5 (Enable6, _EN);
	buf U_c6 (Enable7, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="APA";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!EN && !CLR )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(negedge EN => (Q+:D))=(tpdLH_EN_to_Q, tpdHL_EN_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge CLR, posedge EN, 0.0, NOTIFY_REG);
	$hold (posedge EN, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDLCI
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QBAR, _CLK=EN, CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module LDLCI(CLR, EN, QBAR,D);
 input D,CLR,EN;
 output QBAR;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(QBAR_, D, EN, CLR, GND, NOTIFY_REG);
  not INV_Q(QBAR, QBAR_);

// some temp signals created for timing checking sections

	not U_I0 (_EN, EN);
	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,_CLR);
	and U_c1 (Enable2, _EN, _CLR);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, _EN, _CLR);
	buf U_c5 (Enable6, _EN);
	buf U_c6 (Enable7, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="APA";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QBAR = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_QBAR = (0.1:0.1:0.1);

        //check timing delay for output



	if(!EN && !CLR )
        (D => QBAR) = (tpdLH_D_to_QBAR, tpdHL_D_to_QBAR);

	if(Enable1)
	(negedge EN => (QBAR+:D))=(tpdLH_EN_to_QBAR, tpdHL_EN_to_QBAR);
	(posedge CLR => (QBAR +: 1'b0)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);
	(negedge CLR => (QBAR+:D)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge CLR, posedge EN, 0.0, NOTIFY_REG);
	$hold (posedge EN, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDLI
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QBAR, _CLK=EN, D=D ];
-----------------------------------------------------------------*/

module LDLI(EN, QBAR,D);
 input D,EN;
 output QBAR;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 DL2C_UDP DL_U0(QBAR_, D, EN, GND, GND, NOTIFY_REG);
  not INV_Q(QBAR, QBAR_);

// some temp signals created for timing checking sections

	not U_I0 (_EN, EN);
	buf U_c1 (Enable2, _EN);
	buf U_c3 (Enable4, _EN);
	buf U_c5 (Enable6, _EN);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="APA";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QBAR = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_QBAR = (0.1:0.1:0.1);

        //check timing delay for output



	if(!EN )
        (D => QBAR) = (tpdLH_D_to_QBAR, tpdHL_D_to_QBAR);

	(negedge EN => (QBAR+:D))=(tpdLH_EN_to_QBAR, tpdHL_EN_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge EN, 0.0, NOTIFY_REG);
	$hold(posedge EN, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge EN, 0.0, NOTIFY_REG);
	$hold(posedge EN, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge EN, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDLS
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=EN, PRE=SET, D=D ];
-----------------------------------------------------------------*/

module LDLS(SET, EN, Q,D);
 input D,SET,EN;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(SET_, SET);
 DL2C_UDP DL_U0(Q, D, EN, GND, SET, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_EN, EN);
	not U_I1 (_SET, SET);
	buf U_c0 (Enable1,_SET);
	and U_c1 (Enable2, _EN, _SET);
	buf U_c3 (Enable4, _EN);
	buf U_c4 (Enable5, _SET);
	and U_c5 (Enable6, _EN, _SET);
	buf U_c6 (Enable7, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="APA";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$SET = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_SET_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_SET_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!EN && !SET )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(negedge EN => (Q+:D))=(tpdLH_EN_to_Q, tpdHL_EN_to_Q);
	(posedge SET => (Q +: 1'b1)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);
       if(!EN )
	(negedge SET => (Q+:D)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge SET, 0.0, 0, NOTIFY_REG);

	$recovery (negedge SET, posedge EN, 0.0, NOTIFY_REG);
	$hold (posedge EN, negedge SET, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDLSI
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QBAR, _CLK=EN, PRE=SET, D=D ];
-----------------------------------------------------------------*/

module LDLSI(SET, EN, QBAR,D);
 input D,SET,EN;
 output QBAR;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(SET_, SET);
 DL2C_UDP DL_U0(QBAR_, D, EN, GND, SET, NOTIFY_REG);
  not INV_Q(QBAR, QBAR_);

// some temp signals created for timing checking sections

	not U_I0 (_EN, EN);
	not U_I1 (_SET, SET);
	buf U_c0 (Enable1,_SET);
	and U_c1 (Enable2, _EN, _SET);
	buf U_c3 (Enable4, _EN);
	buf U_c4 (Enable5, _SET);
	and U_c5 (Enable6, _EN, _SET);
	buf U_c6 (Enable7, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="APA";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$SET = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QBAR = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_SET_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_SET_to_QBAR = (0.1:0.1:0.1);

        //check timing delay for output



	if(!EN && !SET )
        (D => QBAR) = (tpdLH_D_to_QBAR, tpdHL_D_to_QBAR);

	if(Enable1)
	(negedge EN => (QBAR+:D))=(tpdLH_EN_to_QBAR, tpdHL_EN_to_QBAR);
	(posedge SET => (QBAR +: 1'b1)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);
       if(!EN )
	(negedge SET => (QBAR+:D)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge SET, 0.0, 0, NOTIFY_REG);

	$recovery (negedge SET, posedge EN, 0.0, NOTIFY_REG);
	$hold (posedge EN, negedge SET, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDS
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =EN, PRE=SET, D=D ];
-----------------------------------------------------------------*/

module LDS(SET, EN, Q,D);
 input D,SET,EN;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(SET_, SET);
 not INV_CLK(EN_, EN);
 DL2C_UDP DL_U0(Q, D, EN_, GND, SET, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I1 (_SET, SET);
	buf U_c0 (Enable1,_SET);
	and U_c1 (Enable2, EN, _SET);
	buf U_c3 (Enable4, EN);
	buf U_c4 (Enable5, _SET);
	and U_c5 (Enable6, EN, _SET);
	buf U_c6 (Enable7, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="APA";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$SET = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_SET_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_SET_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(EN && !SET )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(posedge EN => (Q+:D))=(tpdLH_EN_to_Q, tpdHL_EN_to_Q);
	(posedge SET => (Q +: 1'b1)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);
       if(EN )
	(negedge SET => (Q+:D)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge SET, 0.0, 0, NOTIFY_REG);

	$recovery (negedge SET, negedge EN, 0.0, NOTIFY_REG);
	$hold (negedge EN, negedge SET, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDSI
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QBAR, CLK =EN, PRE=SET, D=D ];
-----------------------------------------------------------------*/

module LDSI(SET, EN, QBAR,D);
 input D,SET,EN;
 output QBAR;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(SET_, SET);
 not INV_CLK(EN_, EN);
 DL2C_UDP DL_U0(QBAR_, D, EN_, GND, SET, NOTIFY_REG);
  not INV_Q(QBAR, QBAR_);

// some temp signals created for timing checking sections

	not U_I1 (_SET, SET);
	buf U_c0 (Enable1,_SET);
	and U_c1 (Enable2, EN, _SET);
	buf U_c3 (Enable4, EN);
	buf U_c4 (Enable5, _SET);
	and U_c5 (Enable6, EN, _SET);
	buf U_c6 (Enable7, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="APA";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$SET = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QBAR = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_SET_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_SET_to_QBAR = (0.1:0.1:0.1);

        //check timing delay for output



	if(EN && !SET )
        (D => QBAR) = (tpdLH_D_to_QBAR, tpdHL_D_to_QBAR);

	if(Enable1)
	(posedge EN => (QBAR+:D))=(tpdLH_EN_to_QBAR, tpdHL_EN_to_QBAR);
	(posedge SET => (QBAR +: 1'b1)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);
       if(EN )
	(negedge SET => (QBAR+:D)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge SET, 0.0, 0, NOTIFY_REG);

	$recovery (negedge SET, negedge EN, 0.0, NOTIFY_REG);
	$hold (negedge EN, negedge SET, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MUX2H
 CELL TYPE : comb
 CELL LOGIC : Y = (A & !S) + (B & S)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MUX2H(Y,A,S,B);
 input A,S,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_17(S_, S);
 UDP_MUX2   U75(Y, A, B, S_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(S => Y ) = ( tpdLH_S_to_Y, tpdHL_S_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MUX2L
 CELL TYPE : comb
 CELL LOGIC : Y = A & S + B & !S
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MUX2L(Y,A,S,B);
 input A,S,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_18(S_, S);
 UDP_MUX2   U79(Y, A, B, S);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(S => Y ) = ( tpdLH_S_to_Y, tpdHL_S_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND2
 CELL TYPE : comb
 CELL LOGIC : Y = !A + !B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND2(Y,A,B);
 input A,B;
 output Y;

 not	INV_19(A_, A);
 not	INV_20(B_, B);
 or       U83(Y, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND2FT
 CELL TYPE : comb
 CELL LOGIC : Y = A + !B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND2FT(Y,A,B);
 input A,B;
 output Y;

 not	INV_21(B_, B);
 or       U86(Y, A, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND3
 CELL TYPE : comb
 CELL LOGIC : Y = !A + !B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_22(A_, A);
 not	INV_23(B_, B);
 not	INV_24(C_, C);
 or       U90(NET_0_0, A_, B_);
 or       U91(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND3FFT
 CELL TYPE : comb
 CELL LOGIC : Y = A + B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND3FFT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_25(C_, C);
 or       U95(NET_0_0, A, B);
 or       U96(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND3FTT
 CELL TYPE : comb
 CELL LOGIC : Y = A + !B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND3FTT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_26(B_, B);
 not	INV_27(C_, C);
 or       U100(NET_0_0, A, B_);
 or       U101(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR2
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR2(Y,A,B);
 input A,B;
 output Y;

 not	INV_28(A_, A);
 not	INV_29(B_, B);
 and      U104(Y, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR2FT
 CELL TYPE : comb
 CELL LOGIC : Y = A & !B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR2FT(Y,A,B);
 input A,B;
 output Y;

 not	INV_30(B_, B);
 and      U107(Y, A, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR3
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_31(A_, A);
 not	INV_32(B_, B);
 not	INV_33(C_, C);
 and      U111(NET_0_0, A_, B_);
 and      U112(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR3FFT
 CELL TYPE : comb
 CELL LOGIC : Y = A & B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR3FFT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_34(C_, C);
 and      U116(NET_0_0, A, B);
 and      U117(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR3FTT
 CELL TYPE : comb
 CELL LOGIC : Y = A & !B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR3FTT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_35(B_, B);
 not	INV_36(C_, C);
 and      U121(NET_0_0, A, B_);
 and      U122(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NUBBLE
 CELL TYPE : comb
 CELL LOGIC : Y = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NUBBLE(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA21
 CELL TYPE : comb
 CELL LOGIC : Y = (A & C) + (B & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA21(Y,A,C,B);
 input A,C,B;
 output Y;
 wire NET_0_0, NET_0_1;

 and      U126(NET_0_0, A, C);
 or       U127(Y, NET_0_0, NET_0_1);
 and      U129(NET_0_1, B, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA21FTF
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & !C) + (B & !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA21FTF(Y,A,C,B);
 input A,C,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_37(A_, A);
 not	INV_38(C_, C);
 and      U133(NET_0_0, A_, C_);
 or       U134(Y, NET_0_0, NET_0_1);
 and      U136(NET_0_1, B, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA21FTT
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & C) + (B & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA21FTT(Y,A,C,B);
 input A,C,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_39(A_, A);
 and      U140(NET_0_0, A_, C);
 or       U141(Y, NET_0_0, NET_0_1);
 and      U143(NET_0_1, B, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA21TTF
 CELL TYPE : comb
 CELL LOGIC : Y = (A & !C) + (B & !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA21TTF(Y,A,C,B);
 input A,C,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_40(C_, C);
 and      U147(NET_0_0, A, C_);
 or       U148(Y, NET_0_0, NET_0_1);
 and      U150(NET_0_1, B, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OAI21
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OAI21(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_41(A_, A);
 not	INV_42(B_, B);
 not	INV_43(C_, C);
 and      U154(NET_0_0, A_, B_);
 or       U155(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OAI21FTF
 CELL TYPE : comb
 CELL LOGIC : Y = A & !B + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OAI21FTF(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_44(B_, B);
 and      U159(NET_0_0, A, B_);
 or       U160(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OAI21FTT
 CELL TYPE : comb
 CELL LOGIC : Y = A & !B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OAI21FTT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_45(B_, B);
 not	INV_46(C_, C);
 and      U164(NET_0_0, A, B_);
 or       U165(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OAI21TTF
 CELL TYPE : comb
 CELL LOGIC : Y = C + !A & !B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OAI21TTF(Y,C,A,B);
 input C,A,B;
 output Y;
 wire NET_0_0;

 not	INV_47(A_, A);
 not	INV_48(B_, B);
 or       U168(Y, C, NET_0_0);
 and      U170(NET_0_0, A_, B_);

       specify

		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25HH
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25HH(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25HL
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25HL(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25HN
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25HN(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25LH
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25LH(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25LL
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25LL(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25LN
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25LN(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25LPHH
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25LPHH(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25LPHL
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25LPHL(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25LPHN
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25LPHN(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25LPLH
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25LPLH(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25LPLL
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25LPLL(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25LPLN
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25LPLN(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB33LH
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB33LH(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB33LL
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB33LL(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB33LN
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB33LN(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB33PH
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB33PH(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB33PL
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB33PL(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB33PN
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB33PN(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR2
 CELL TYPE : comb
 CELL LOGIC : Y = A + B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR2(Y,A,B);
 input A,B;
 output Y;

 or       U173(Y, A, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR2FT
 CELL TYPE : comb
 CELL LOGIC : Y = !A + B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR2FT(Y,A,B);
 input A,B;
 output Y;

 not	INV_49(A_, A);
 or       U176(Y, A_, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR3
 CELL TYPE : comb
 CELL LOGIC : Y = A + B + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 or       U180(NET_0_0, A, B);
 or       U181(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR3FFT
 CELL TYPE : comb
 CELL LOGIC : Y = !A + !B + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR3FFT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_50(A_, A);
 not	INV_51(B_, B);
 or       U185(NET_0_0, A_, B_);
 or       U186(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR3FTT
 CELL TYPE : comb
 CELL LOGIC : Y = !A + B + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR3FTT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_52(A_, A);
 or       U190(NET_0_0, A_, B);
 or       U191(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : PWR
 CELL TYPE : comb
 CELL LOGIC : Y = 1
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module PWR(Y);
 output Y;

 supply1    Y;

       specify

		specparam MacroType = "comb";

		//pin to pin path delay 

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XNOR2
 CELL TYPE : comb
 CELL LOGIC : Y = !(A ^ B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XNOR2(Y,A,B);
 input A,B;
 output Y;

 not	INV_53(A_, A);
 not	INV_54(B_, B);
 UDPN_MUX2  U194(Y, B, B_, A_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XNOR2FT
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A ^ B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XNOR2FT(Y,A,B);
 input A,B;
 output Y;

 not	INV_55(A_, A);
 not	INV_56(B_, B);
 UDPN_MUX2  U198(Y, B, B_, A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XOR2
 CELL TYPE : comb
 CELL LOGIC : Y = (A ^ B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XOR2(Y,A,B);
 input A,B;
 output Y;

 not	INV_57(A_, A);
 not	INV_58(B_, B);
 UDP_MUX2   U202(Y, B, B_, A_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XOR2FT
 CELL TYPE : comb
 CELL LOGIC : Y = (!A ^ B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XOR2FT(Y,A,B);
 input A,B;
 output Y;

 not	INV_59(A_, A);
 not	INV_60(B_, B);
 UDP_MUX2   U206(Y, B, B_, A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFF
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFF(CLK, Q,D);
 input D,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFB
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, CLR=CLR, PRE=SET, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFB(SET, CLR, CLK, Q,D);
 input D,SET,CLR,CLK;
 output Q;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(SET_0, SET);
 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(Q, D,CLK,CLR_0, SET_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_SET, SET);
      not U_I2 (_CLR, CLR);
      and U_c0 (Enable1, _CLR, _SET);
       buf U_c2 (Enable2, _CLR);
       buf U_c4 (Enable4, _SET);
      and U_c6 (Enable5, _CLR, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_SET_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_SET_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(posedge SET => (Q +: 1'b1)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK &&& Enable2, negedge SET,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable4, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge SET &&& _CLR,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge SET, posedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(negedge CLR, posedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFBI
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QBAR, CLK =CLK, CLR=CLR, PRE=SET, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFBI(SET, CLR, CLK, QBAR,D);
 input D,SET,CLR,CLK;
 output QBAR;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(SET_0, SET);
 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(q_tmp, D,CLK,CLR_0, SET_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QBAR,q_tmp);

// some temp signals created for timing checking sections

      not U_I1 (_SET, SET);
      not U_I2 (_CLR, CLR);
      and U_c0 (Enable1, _CLR, _SET);
       buf U_c2 (Enable2, _CLR);
       buf U_c4 (Enable4, _SET);
      and U_c6 (Enable5, _CLR, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdLH_SET_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_SET_to_QBAR = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QBAR +: D))=(tpdLH_CLK_to_QBAR, tpdHL_CLK_to_QBAR);
	(posedge CLR => (QBAR +: 1'b0)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);
	(posedge SET => (QBAR +: 1'b1)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK &&& Enable2, negedge SET,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable4, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge SET &&& _CLR,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge SET, posedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(negedge CLR, posedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFC
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFC(CLR, CLK, Q,D);
 input D,CLR,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(Q, D,CLK,CLR_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I2 (_CLR, CLR);
      buf U_c0 (Enable1,_CLR);
       buf U_c2 (Enable2, _CLR);
      buf U_c6 (Enable5, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge CLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFCI
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QBAR, CLK =CLK, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFCI(CLR, CLK, QBAR,D);
 input D,CLR,CLK;
 output QBAR;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(q_tmp, D,CLK,CLR_0, VCC_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QBAR,q_tmp);

// some temp signals created for timing checking sections

      not U_I2 (_CLR, CLR);
      buf U_c0 (Enable1,_CLR);
       buf U_c2 (Enable2, _CLR);
      buf U_c6 (Enable5, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QBAR = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QBAR +: D))=(tpdLH_CLK_to_QBAR, tpdHL_CLK_to_QBAR);
	(posedge CLR => (QBAR +: 1'b0)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge CLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFI
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QBAR, CLK =CLK, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFI(CLK, QBAR,D);
 input D,CLK;
 output QBAR;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpr DF_0(q_tmp, D,CLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QBAR,q_tmp);

// some temp signals created for timing checking sections


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QBAR = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QBAR +: D))=(tpdLH_CLK_to_QBAR, tpdHL_CLK_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFL
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFL(CLK, Q,D);
 input D,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpf DF_0(Q, D,CLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK, 0.0, NOTIFY_REG);
	$hold(negedge CLK, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFLB
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, CLR=CLR, PRE=SET, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFLB(SET, CLR, CLK, Q,D);
 input D,SET,CLR,CLK;
 output Q;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(SET_0, SET);
 not INV_CLR_0(CLR_0, CLR);

 Dffpf DF_0(Q, D,CLK,CLR_0, SET_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_SET, SET);
      not U_I2 (_CLR, CLR);
      and U_c0 (Enable1, _CLR, _SET);
       buf U_c2 (Enable2, _CLR);
       buf U_c4 (Enable4, _SET);
      and U_c6 (Enable5, _CLR, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_SET_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_SET_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(posedge SET => (Q +: 1'b1)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK &&& Enable2, negedge SET,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable4, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge SET &&& _CLR,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge SET, negedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(negedge CLR, negedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFLBI
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QBAR, _CLK=CLK, CLR=CLR, PRE=SET, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFLBI(SET, CLR, CLK, QBAR,D);
 input D,SET,CLR,CLK;
 output QBAR;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(SET_0, SET);
 not INV_CLR_0(CLR_0, CLR);

 Dffpf DF_0(q_tmp, D,CLK,CLR_0, SET_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QBAR,q_tmp);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_SET, SET);
      not U_I2 (_CLR, CLR);
      and U_c0 (Enable1, _CLR, _SET);
       buf U_c2 (Enable2, _CLR);
       buf U_c4 (Enable4, _SET);
      and U_c6 (Enable5, _CLR, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdLH_SET_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_SET_to_QBAR = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QBAR +: D))=(tpdLH_CLK_to_QBAR, tpdHL_CLK_to_QBAR);
	(posedge CLR => (QBAR +: 1'b0)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);
	(posedge SET => (QBAR +: 1'b1)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK &&& Enable2, negedge SET,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable4, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge SET &&& _CLR,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge SET, negedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(negedge CLR, negedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFLC
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFLC(CLR, CLK, Q,D);
 input D,CLR,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpf DF_0(Q, D,CLK,CLR_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I2 (_CLR, CLR);
      buf U_c0 (Enable1,_CLR);
       buf U_c2 (Enable2, _CLR);
      buf U_c6 (Enable5, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(negedge CLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFLCI
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QBAR, _CLK=CLK, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFLCI(CLR, CLK, QBAR,D);
 input D,CLR,CLK;
 output QBAR;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpf DF_0(q_tmp, D,CLK,CLR_0, VCC_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QBAR,q_tmp);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I2 (_CLR, CLR);
      buf U_c0 (Enable1,_CLR);
       buf U_c2 (Enable2, _CLR);
      buf U_c6 (Enable5, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QBAR = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QBAR +: D))=(tpdLH_CLK_to_QBAR, tpdHL_CLK_to_QBAR);
	(posedge CLR => (QBAR +: 1'b0)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(negedge CLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFLI
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QBAR, _CLK=CLK, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFLI(CLK, QBAR,D);
 input D,CLK;
 output QBAR;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpf DF_0(q_tmp, D,CLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QBAR,q_tmp);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QBAR = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QBAR +: D))=(tpdLH_CLK_to_QBAR, tpdHL_CLK_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK, 0.0, NOTIFY_REG);
	$hold(negedge CLK, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFLS
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, PRE=SET, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFLS(SET, CLK, Q,D);
 input D,SET,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(SET_0, SET);

 Dffpf DF_0(Q, D,CLK,VCC_0, SET_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_SET, SET);
      buf U_c0 (Enable1, _SET);
       buf U_c4 (Enable4, _SET);
       buf U_c6 (Enable5, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_SET_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_SET_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge SET => (Q +: 1'b1)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK, negedge SET,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge SET,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge SET, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFLSI
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QBAR, _CLK=CLK, PRE=SET, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFLSI(SET, CLK, QBAR,D);
 input D,SET,CLK;
 output QBAR;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(SET_0, SET);

 Dffpf DF_0(q_tmp, D,CLK,VCC_0, SET_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QBAR,q_tmp);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_SET, SET);
      buf U_c0 (Enable1, _SET);
       buf U_c4 (Enable4, _SET);
       buf U_c6 (Enable5, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdLH_SET_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_SET_to_QBAR = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QBAR +: D))=(tpdLH_CLK_to_QBAR, tpdHL_CLK_to_QBAR);
	(posedge SET => (QBAR +: 1'b1)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK, negedge SET,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge SET,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge SET, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFS
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, PRE=SET, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFS(SET, CLK, Q,D);
 input D,SET,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(SET_0, SET);

 Dffpr DF_0(Q, D,CLK,VCC_0, SET_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_SET, SET);
      buf U_c0 (Enable1, _SET);
       buf U_c4 (Enable4, _SET);
       buf U_c6 (Enable5, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_SET_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_SET_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge SET => (Q +: 1'b1)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK, negedge SET,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge SET,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge SET, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFSI
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QBAR, CLK =CLK, PRE=SET, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFSI(SET, CLK, QBAR,D);
 input D,SET,CLK;
 output QBAR;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(SET_0, SET);

 Dffpr DF_0(q_tmp, D,CLK,VCC_0, SET_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QBAR,q_tmp);

// some temp signals created for timing checking sections

      not U_I1 (_SET, SET);
      buf U_c0 (Enable1, _SET);
       buf U_c4 (Enable4, _SET);
       buf U_c6 (Enable5, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdLH_SET_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_SET_to_QBAR = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QBAR +: D))=(tpdLH_CLK_to_QBAR, tpdHL_CLK_to_QBAR);
	(posedge SET => (QBAR +: 1'b1)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK, negedge SET,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge SET,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge SET, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLIB25
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLIB25(Y,GL,PAD,A);
 input PAD,A;
 output Y,GL;

 buf	BUF_U_00(Y,PAD);
 buf	BUF_U_01(GL,A);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLIB25LP
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLIB25LP(Y,GL,PAD,A);
 input PAD,A;
 output Y,GL;

 buf	BUF_U_00(Y,PAD);
 buf	BUF_U_01(GL,A);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLIB25LPS
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLIB25LPS(Y,GL,PAD,A);
 input PAD,A;
 output Y,GL;

 buf	BUF_U_00(Y,PAD);
 buf	BUF_U_01(GL,A);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLIB25LPU
 CELL TYPE : comb
 CELL LOGIC : Y#up=PAD ; GL=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLIB25LPU(Y,GL,PAD,A);
 input PAD,A;
 output Y,GL;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 buf	BUF_U_01(GL,A);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLIB25LPUS
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLIB25LPUS(Y,GL,PAD,A);
 input PAD,A;
 output Y,GL;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 buf	BUF_U_01(GL,A);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLIB25S
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLIB25S(Y,GL,PAD,A);
 input PAD,A;
 output Y,GL;

 buf	BUF_U_00(Y,PAD);
 buf	BUF_U_01(GL,A);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLIB25U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLIB25U(Y,GL,PAD,A);
 input PAD,A;
 output Y,GL;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 buf	BUF_U_01(GL,A);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLIB25US
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLIB25US(Y,GL,PAD,A);
 input PAD,A;
 output Y,GL;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 buf	BUF_U_01(GL,A);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLIB33
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLIB33(Y,GL,PAD,A);
 input PAD,A;
 output Y,GL;

 buf	BUF_U_00(Y,PAD);
 buf	BUF_U_01(GL,A);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLIB33S
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLIB33S(Y,GL,PAD,A);
 input PAD,A;
 output Y,GL;

 buf	BUF_U_00(Y,PAD);
 buf	BUF_U_01(GL,A);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLIB33U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLIB33U(Y,GL,PAD,A);
 input PAD,A;
 output Y,GL;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 buf	BUF_U_01(GL,A);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLIB33US
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLIB33US(Y,GL,PAD,A);
 input PAD,A;
 output Y,GL;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 buf	BUF_U_01(GL,A);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIB25
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIB25(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_61(EN_, EN);
 UDP_MUX2   U210(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIB33
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIB33(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_62(EN_, EN);
 UDP_MUX2   U214(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIB25LP
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIB25LP(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_63(EN_, EN);
 UDP_MUX2   U218(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIB25S
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIB25S(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_64(EN_, EN);
 UDP_MUX2   U222(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIB33S
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIB33S(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_65(EN_, EN);
 UDP_MUX2   U226(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIB25LPS
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIB25LPS(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_66(EN_, EN);
 UDP_MUX2   U230(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIB25U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIB25U(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 not	INV_67(EN_, EN);
 UDP_MUX2   U234(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIB33U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIB33U(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 not	INV_68(EN_, EN);
 UDP_MUX2   U238(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIB25LPU
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIB25LPU(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 not	INV_69(EN_, EN);
 UDP_MUX2   U242(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIB25US
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIB25US(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 not	INV_70(EN_, EN);
 UDP_MUX2   U246(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIB33US
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIB33US(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 not	INV_71(EN_, EN);
 UDP_MUX2   U250(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIB25LPUS
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIB25LPUS(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 not	INV_72(EN_, EN);
 UDP_MUX2   U254(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIBL25
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIBL25(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_73(EN_, EN);
 UDP_MUX2   U258(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIBL33
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIBL33(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_74(EN_, EN);
 UDP_MUX2   U262(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIBL25LP
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIBL25LP(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_75(EN_, EN);
 UDP_MUX2   U266(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIBL25S
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIBL25S(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_76(EN_, EN);
 UDP_MUX2   U270(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIBL33S
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIBL33S(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_77(EN_, EN);
 UDP_MUX2   U274(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIBL25LPS
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIBL25LPS(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_78(EN_, EN);
 UDP_MUX2   U278(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIBL33US
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIBL33US(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 not	INV_79(EN_, EN);
 UDP_MUX2   U282(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIBL25LPUS
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIBL25LPUS(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 not	INV_80(EN_, EN);
 UDP_MUX2   U286(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIBL25US
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIBL25US(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 not	INV_81(EN_, EN);
 UDP_MUX2   U290(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIBL25LPU
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIBL25LPU(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 not	INV_82(EN_, EN);
 UDP_MUX2   U294(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIBL33U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIBL33U(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 not	INV_83(EN_, EN);
 UDP_MUX2   U298(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIBL25U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIBL25U(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 not	INV_84(EN_, EN);
 UDP_MUX2   U302(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25HH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25HH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U306(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25HL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25HL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U309(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25HN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25HN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U312(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U315(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U318(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U321(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25HHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25HHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U324(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25HLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25HLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U327(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25HNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25HNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U330(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U333(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U336(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U339(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPHH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPHH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U342(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPHL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPHL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U345(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPHN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPHN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U348(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPLH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPLH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U351(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPLL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPLL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U354(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPLN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPLN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U357(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPHHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPHHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U360(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPHLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPHLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U363(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPHNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPHNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U366(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPLHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPLHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U369(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPLLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPLLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U372(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPLNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPLNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U375(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33LH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33LH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U378(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33LL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33LL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U381(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33LN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33LN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U384(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33PH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33PH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U387(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33PL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33PL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U390(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33PN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33PN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U393(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33LHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33LHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U396(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33LLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33LLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U399(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33LNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33LNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U402(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33PHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33PHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U405(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33PLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33PLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U408(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33PNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33PNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U411(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25HH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25HH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_85(EN_, EN);
 bufif1   U414(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25HL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25HL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_86(EN_, EN);
 bufif1   U417(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25HN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25HN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_87(EN_, EN);
 bufif1   U420(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_88(EN_, EN);
 bufif1   U423(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_89(EN_, EN);
 bufif1   U426(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_90(EN_, EN);
 bufif1   U429(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25HHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25HHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_91(EN_, EN);
 bufif1   U432(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25HLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25HLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_92(EN_, EN);
 bufif1   U435(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25HNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25HNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_93(EN_, EN);
 bufif1   U438(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_94(EN_, EN);
 bufif1   U441(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_95(EN_, EN);
 bufif1   U444(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_96(EN_, EN);
 bufif1   U447(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPHH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPHH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_97(EN_, EN);
 bufif1   U450(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPHL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPHL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_98(EN_, EN);
 bufif1   U453(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPHN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPHN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_99(EN_, EN);
 bufif1   U456(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPLH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPLH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_100(EN_, EN);
 bufif1   U459(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPLL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPLL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_101(EN_, EN);
 bufif1   U462(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPLN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPLN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_102(EN_, EN);
 bufif1   U465(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPHHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPHHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_103(EN_, EN);
 bufif1   U468(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPHLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPHLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_104(EN_, EN);
 bufif1   U471(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPHNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPHNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_105(EN_, EN);
 bufif1   U474(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPLHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPLHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_106(EN_, EN);
 bufif1   U477(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPLLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPLLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_107(EN_, EN);
 bufif1   U480(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPLNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPLNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_108(EN_, EN);
 bufif1   U483(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33LH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33LH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_109(EN_, EN);
 bufif1   U486(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33LL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33LL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_110(EN_, EN);
 bufif1   U489(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33LN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33LN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_111(EN_, EN);
 bufif1   U492(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33PH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33PH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_112(EN_, EN);
 bufif1   U495(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33PL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33PL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_113(EN_, EN);
 bufif1   U498(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33PN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33PN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_114(EN_, EN);
 bufif1   U501(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33LHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33LHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_115(EN_, EN);
 bufif1   U504(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33LLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33LLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_116(EN_, EN);
 bufif1   U507(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33LNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33LNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_117(EN_, EN);
 bufif1   U510(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33PHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33PHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_118(EN_, EN);
 bufif1   U513(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33PLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33PLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_119(EN_, EN);
 bufif1   U516(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33PNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33PNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_120(EN_, EN);
 bufif1   U519(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25HH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25HH(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U522(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25HL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25HL(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U525(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25HN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25HN(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U528(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25LH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25LH(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U531(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25LL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25LL(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U534(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25LN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25LN(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U537(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25LPLH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25LPLH(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U540(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25LPLL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25LPLL(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U543(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25LPLN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25LPLN(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U546(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25LPHH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25LPHH(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U549(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25LPHL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25LPHL(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U552(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25LPHN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25LPHN(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U555(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB33LH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB33LH(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U558(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB33LL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB33LL(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U561(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB33LN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB33LN(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U564(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB33PH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB33PH(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U567(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB33PL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB33PL(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U570(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB33PN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB33PN(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U573(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25HH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25HH(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_121(EN_, EN);
 bufif1   U576(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25HL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25HL(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_122(EN_, EN);
 bufif1   U579(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25HN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25HN(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_123(EN_, EN);
 bufif1   U582(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25LH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25LH(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_124(EN_, EN);
 bufif1   U585(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25LL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25LL(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_125(EN_, EN);
 bufif1   U588(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25LN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25LN(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_126(EN_, EN);
 bufif1   U591(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25LPLH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25LPLH(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_127(EN_, EN);
 bufif1   U594(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25LPLL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25LPLL(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_128(EN_, EN);
 bufif1   U597(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25LPLN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25LPLN(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_129(EN_, EN);
 bufif1   U600(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25LPHH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25LPHH(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_130(EN_, EN);
 bufif1   U603(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25LPHL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25LPHL(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_131(EN_, EN);
 bufif1   U606(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25LPHN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25LPHN(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_132(EN_, EN);
 bufif1   U609(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL33LH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL33LH(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_133(EN_, EN);
 bufif1   U612(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL33LL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL33LL(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_134(EN_, EN);
 bufif1   U615(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL33LN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL33LN(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_135(EN_, EN);
 bufif1   U618(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL33PH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL33PH(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_136(EN_, EN);
 bufif1   U621(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL33PL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL33PL(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_137(EN_, EN);
 bufif1   U624(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL33PN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL33PN(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_138(EN_, EN);
 bufif1   U627(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25LLU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25LLU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_139(EN_, EN);
 bufif1   U630(PAD, D, DE);
 not	INV_140(EN_, EN);
 UDP_MUX2   U633(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25LL
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25LL(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_141(EN_, EN);
 bufif1   U637(PAD, D, DE);
 not	INV_142(EN_, EN);
 UDP_MUX2   U640(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25LNU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25LNU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_143(EN_, EN);
 bufif1   U644(PAD, D, DE);
 not	INV_144(EN_, EN);
 UDP_MUX2   U647(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25LN
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25LN(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_145(EN_, EN);
 bufif1   U651(PAD, D, DE);
 not	INV_146(EN_, EN);
 UDP_MUX2   U654(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25LHU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25LHU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_147(EN_, EN);
 bufif1   U658(PAD, D, DE);
 not	INV_148(EN_, EN);
 UDP_MUX2   U661(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25LH
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25LH(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_149(EN_, EN);
 bufif1   U665(PAD, D, DE);
 not	INV_150(EN_, EN);
 UDP_MUX2   U668(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25HLU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25HLU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_151(EN_, EN);
 bufif1   U672(PAD, D, DE);
 not	INV_152(EN_, EN);
 UDP_MUX2   U675(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25HL
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25HL(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_153(EN_, EN);
 bufif1   U679(PAD, D, DE);
 not	INV_154(EN_, EN);
 UDP_MUX2   U682(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25HNU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25HNU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_155(EN_, EN);
 bufif1   U686(PAD, D, DE);
 not	INV_156(EN_, EN);
 UDP_MUX2   U689(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25HN
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25HN(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_157(EN_, EN);
 bufif1   U693(PAD, D, DE);
 not	INV_158(EN_, EN);
 UDP_MUX2   U696(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25HHU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25HHU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_159(EN_, EN);
 bufif1   U700(PAD, D, DE);
 not	INV_160(EN_, EN);
 UDP_MUX2   U703(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25HH
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25HH(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_161(EN_, EN);
 bufif1   U707(PAD, D, DE);
 not	INV_162(EN_, EN);
 UDP_MUX2   U710(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25LPLLU
 CELL TYPE : comb
 CELL LOGIC : Y#up=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25LPLLU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 tri1	PAD;
 buf	BUF_U_00(Y,PAD);
 not	INV_163(EN_, EN);
 bufif1   U714(PAD, D, DE);
 not	INV_164(EN_, EN);
 UDP_MUX2   U717(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25LPLL
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25LPLL(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_165(EN_, EN);
 bufif1   U721(PAD, D, DE);
 not	INV_166(EN_, EN);
 UDP_MUX2   U724(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25LPLNU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25LPLNU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_167(EN_, EN);
 bufif1   U728(PAD, D, DE);
 not	INV_168(EN_, EN);
 UDP_MUX2   U731(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25LPLN
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25LPLN(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_169(EN_, EN);
 bufif1   U735(PAD, D, DE);
 not	INV_170(EN_, EN);
 UDP_MUX2   U738(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25LPLHU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25LPLHU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_171(EN_, EN);
 bufif1   U742(PAD, D, DE);
 not	INV_172(EN_, EN);
 UDP_MUX2   U745(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25LPLH
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25LPLH(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_173(EN_, EN);
 bufif1   U749(PAD, D, DE);
 not	INV_174(EN_, EN);
 UDP_MUX2   U752(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25LPHLU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25LPHLU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_175(EN_, EN);
 bufif1   U756(PAD, D, DE);
 not	INV_176(EN_, EN);
 UDP_MUX2   U759(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25LPHL
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25LPHL(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_177(EN_, EN);
 bufif1   U763(PAD, D, DE);
 not	INV_178(EN_, EN);
 UDP_MUX2   U766(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25LPHN
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25LPHN(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_179(EN_, EN);
 bufif1   U770(PAD, D, DE);
 not	INV_180(EN_, EN);
 UDP_MUX2   U773(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25LPHNU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25LPHNU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_181(EN_, EN);
 bufif1   U777(PAD, D, DE);
 not	INV_182(EN_, EN);
 UDP_MUX2   U780(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25LPHHU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25LPHHU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_183(EN_, EN);
 bufif1   U784(PAD, D, DE);
 not	INV_184(EN_, EN);
 UDP_MUX2   U787(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB25LPHH
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB25LPHH(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_185(EN_, EN);
 bufif1   U791(PAD, D, DE);
 not	INV_186(EN_, EN);
 UDP_MUX2   U794(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB33LLU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB33LLU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_187(EN_, EN);
 bufif1   U798(PAD, D, DE);
 not	INV_188(EN_, EN);
 UDP_MUX2   U801(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB33LL
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB33LL(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_189(EN_, EN);
 bufif1   U805(PAD, D, DE);
 not	INV_190(EN_, EN);
 UDP_MUX2   U808(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB33LNU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB33LNU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_191(EN_, EN);
 bufif1   U812(PAD, D, DE);
 not	INV_192(EN_, EN);
 UDP_MUX2   U815(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB33LN
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB33LN(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_193(EN_, EN);
 bufif1   U819(PAD, D, DE);
 not	INV_194(EN_, EN);
 UDP_MUX2   U822(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB33LHU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB33LHU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_195(EN_, EN);
 bufif1   U826(PAD, D, DE);
 not	INV_196(EN_, EN);
 UDP_MUX2   U829(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB33LH
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB33LH(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_197(EN_, EN);
 bufif1   U833(PAD, D, DE);
 not	INV_198(EN_, EN);
 UDP_MUX2   U836(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB33PLU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB33PLU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_199(EN_, EN);
 bufif1   U840(PAD, D, DE);
 not	INV_200(EN_, EN);
 UDP_MUX2   U843(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB33PL
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB33PL(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_201(EN_, EN);
 bufif1   U847(PAD, D, DE);
 not	INV_202(EN_, EN);
 UDP_MUX2   U850(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB33PNU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB33PNU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_203(EN_, EN);
 bufif1   U854(PAD, D, DE);
 not	INV_204(EN_, EN);
 UDP_MUX2   U857(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB33PN
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB33PN(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_205(EN_, EN);
 bufif1   U861(PAD, D, DE);
 not	INV_206(EN_, EN);
 UDP_MUX2   U864(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB33PHU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB33PHU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_207(EN_, EN);
 bufif1   U868(PAD, D, DE);
 not	INV_208(EN_, EN);
 UDP_MUX2   U871(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOB33PH
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOB33PH(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_209(EN_, EN);
 bufif1   U875(PAD, D, DE);
 not	INV_210(EN_, EN);
 UDP_MUX2   U878(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25LLU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25LLU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_211(EN_, EN);
 bufif1   U882(PAD, D, DE);
 not	INV_212(EN_, EN);
 UDP_MUX2   U885(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25LL
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25LL(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_213(EN_, EN);
 bufif1   U889(PAD, D, DE);
 not	INV_214(EN_, EN);
 UDP_MUX2   U892(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25LNU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25LNU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_215(EN_, EN);
 bufif1   U896(PAD, D, DE);
 not	INV_216(EN_, EN);
 UDP_MUX2   U899(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25LN
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25LN(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_217(EN_, EN);
 bufif1   U903(PAD, D, DE);
 not	INV_218(EN_, EN);
 UDP_MUX2   U906(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25LHU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25LHU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_219(EN_, EN);
 bufif1   U910(PAD, D, DE);
 not	INV_220(EN_, EN);
 UDP_MUX2   U913(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25LH
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25LH(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_221(EN_, EN);
 bufif1   U917(PAD, D, DE);
 not	INV_222(EN_, EN);
 UDP_MUX2   U920(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25HLU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25HLU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_223(EN_, EN);
 bufif1   U924(PAD, D, DE);
 not	INV_224(EN_, EN);
 UDP_MUX2   U927(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25HL
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25HL(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_225(EN_, EN);
 bufif1   U931(PAD, D, DE);
 not	INV_226(EN_, EN);
 UDP_MUX2   U934(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25HNU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25HNU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_227(EN_, EN);
 bufif1   U938(PAD, D, DE);
 not	INV_228(EN_, EN);
 UDP_MUX2   U941(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25HN
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25HN(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_229(EN_, EN);
 bufif1   U945(PAD, D, DE);
 not	INV_230(EN_, EN);
 UDP_MUX2   U948(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25HHU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25HHU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_231(EN_, EN);
 bufif1   U952(PAD, D, DE);
 not	INV_232(EN_, EN);
 UDP_MUX2   U955(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25HH
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25HH(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_233(EN_, EN);
 bufif1   U959(PAD, D, DE);
 not	INV_234(EN_, EN);
 UDP_MUX2   U962(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25LPLLU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25LPLLU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_235(EN_, EN);
 bufif1   U966(PAD, D, DE);
 not	INV_236(EN_, EN);
 UDP_MUX2   U969(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25LPLL
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25LPLL(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_237(EN_, EN);
 bufif1   U973(PAD, D, DE);
 not	INV_238(EN_, EN);
 UDP_MUX2   U976(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25LPLNU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25LPLNU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_239(EN_, EN);
 bufif1   U980(PAD, D, DE);
 not	INV_240(EN_, EN);
 UDP_MUX2   U983(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25LPLN
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25LPLN(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_241(EN_, EN);
 bufif1   U987(PAD, D, DE);
 not	INV_242(EN_, EN);
 UDP_MUX2   U990(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25LPLHU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25LPLHU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_243(EN_, EN);
 bufif1   U994(PAD, D, DE);
 not	INV_244(EN_, EN);
 UDP_MUX2   U997(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25LPLH
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25LPLH(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_245(EN_, EN);
 bufif1   U1001(PAD, D, DE);
 not	INV_246(EN_, EN);
 UDP_MUX2   U1004(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25LPHLU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25LPHLU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_247(EN_, EN);
 bufif1   U1008(PAD, D, DE);
 not	INV_248(EN_, EN);
 UDP_MUX2   U1011(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25LPHL
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25LPHL(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_249(EN_, EN);
 bufif1   U1015(PAD, D, DE);
 not	INV_250(EN_, EN);
 UDP_MUX2   U1018(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25LPHN
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25LPHN(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_251(EN_, EN);
 bufif1   U1022(PAD, D, DE);
 not	INV_252(EN_, EN);
 UDP_MUX2   U1025(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25LPHNU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25LPHNU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_253(EN_, EN);
 bufif1   U1029(PAD, D, DE);
 not	INV_254(EN_, EN);
 UDP_MUX2   U1032(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25LPHHU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25LPHHU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_255(EN_, EN);
 bufif1   U1036(PAD, D, DE);
 not	INV_256(EN_, EN);
 UDP_MUX2   U1039(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL25LPHH
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL25LPHH(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_257(EN_, EN);
 bufif1   U1043(PAD, D, DE);
 not	INV_258(EN_, EN);
 UDP_MUX2   U1046(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL33LLU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL33LLU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_259(EN_, EN);
 bufif1   U1050(PAD, D, DE);
 not	INV_260(EN_, EN);
 UDP_MUX2   U1053(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL33LL
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL33LL(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_261(EN_, EN);
 bufif1   U1057(PAD, D, DE);
 not	INV_262(EN_, EN);
 UDP_MUX2   U1060(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL33LNU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL33LNU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_263(EN_, EN);
 bufif1   U1064(PAD, D, DE);
 not	INV_264(EN_, EN);
 UDP_MUX2   U1067(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL33LN
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL33LN(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_265(EN_, EN);
 bufif1   U1071(PAD, D, DE);
 not	INV_266(EN_, EN);
 UDP_MUX2   U1074(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL33LHU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL33LHU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_267(EN_, EN);
 bufif1   U1078(PAD, D, DE);
 not	INV_268(EN_, EN);
 UDP_MUX2   U1081(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL33LH
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL33LH(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_269(EN_, EN);
 bufif1   U1085(PAD, D, DE);
 not	INV_270(EN_, EN);
 UDP_MUX2   U1088(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL33PLU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL33PLU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_271(EN_, EN);
 bufif1   U1092(PAD, D, DE);
 not	INV_272(EN_, EN);
 UDP_MUX2   U1095(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL33PL
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL33PL(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_273(EN_, EN);
 bufif1   U1099(PAD, D, DE);
 not	INV_274(EN_, EN);
 UDP_MUX2   U1102(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL33PNU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL33PNU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_275(EN_, EN);
 bufif1   U1106(PAD, D, DE);
 not	INV_276(EN_, EN);
 UDP_MUX2   U1109(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL33PN
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL33PN(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_277(EN_, EN);
 bufif1   U1113(PAD, D, DE);
 not	INV_278(EN_, EN);
 UDP_MUX2   U1116(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL33PHU
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD#UP= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL33PHU(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 tri1 PAD;
 not	INV_279(EN_, EN);
 bufif1   U1120(PAD, D, DE);
 not	INV_280(EN_, EN);
 UDP_MUX2   U1123(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIOBL33PH
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; PAD= D@DE ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIOBL33PH(Y,GL,D,DE,EN,A,PAD);
 input D,DE,EN,A;
 output Y,GL;
 inout PAD;
 wire NET_2_0, NET_2_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_281(EN_, EN);
 bufif1   U1127(PAD, D, DE);
 not	INV_282(EN_, EN);
 UDP_MUX2   U1130(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_DE_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_DE_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_DE_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
	    //if(~D)
		(DE => PAD ) = ( tpdLH_DE_to_PAD,tpdHL_DE_to_PAD,tpdLZ_DE_to_PAD,tpdZH_DE_to_PAD,tpdHZ_DE_to_PAD,tpdZL_DE_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25LLU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25LLU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_283(EN_, EN);
 bufif1   U1134(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_284(EN_, EN);
 bufif1   U1137(PAD2, D2, DE2);
 not	INV_285(EN_, EN);
 UDP_MUX2   U1140(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25LL
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25LL(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_286(EN_, EN);
 bufif1   U1144(PAD1, D1, DE1);
 not	INV_287(EN_, EN);
 bufif1   U1147(PAD2, D2, DE2);
 not	INV_288(EN_, EN);
 UDP_MUX2   U1150(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25LNU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25LNU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_289(EN_, EN);
 bufif1   U1154(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_290(EN_, EN);
 bufif1   U1157(PAD2, D2, DE2);
 not	INV_291(EN_, EN);
 UDP_MUX2   U1160(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25LN
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25LN(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_292(EN_, EN);
 bufif1   U1164(PAD1, D1, DE1);
 not	INV_293(EN_, EN);
 bufif1   U1167(PAD2, D2, DE2);
 not	INV_294(EN_, EN);
 UDP_MUX2   U1170(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25LHU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25LHU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_295(EN_, EN);
 bufif1   U1174(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_296(EN_, EN);
 bufif1   U1177(PAD2, D2, DE2);
 not	INV_297(EN_, EN);
 UDP_MUX2   U1180(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25LH
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25LH(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_298(EN_, EN);
 bufif1   U1184(PAD1, D1, DE1);
 not	INV_299(EN_, EN);
 bufif1   U1187(PAD2, D2, DE2);
 not	INV_300(EN_, EN);
 UDP_MUX2   U1190(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25HLU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25HLU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_301(EN_, EN);
 bufif1   U1194(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_302(EN_, EN);
 bufif1   U1197(PAD2, D2, DE2);
 not	INV_303(EN_, EN);
 UDP_MUX2   U1200(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25HL
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25HL(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_304(EN_, EN);
 bufif1   U1204(PAD1, D1, DE1);
 not	INV_305(EN_, EN);
 bufif1   U1207(PAD2, D2, DE2);
 not	INV_306(EN_, EN);
 UDP_MUX2   U1210(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25HNU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25HNU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_307(EN_, EN);
 bufif1   U1214(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_308(EN_, EN);
 bufif1   U1217(PAD2, D2, DE2);
 not	INV_309(EN_, EN);
 UDP_MUX2   U1220(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25HN
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25HN(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_310(EN_, EN);
 bufif1   U1224(PAD1, D1, DE1);
 not	INV_311(EN_, EN);
 bufif1   U1227(PAD2, D2, DE2);
 not	INV_312(EN_, EN);
 UDP_MUX2   U1230(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25HHU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25HHU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_313(EN_, EN);
 bufif1   U1234(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_314(EN_, EN);
 bufif1   U1237(PAD2, D2, DE2);
 not	INV_315(EN_, EN);
 UDP_MUX2   U1240(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25HH
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25HH(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_316(EN_, EN);
 bufif1   U1244(PAD1, D1, DE1);
 not	INV_317(EN_, EN);
 bufif1   U1247(PAD2, D2, DE2);
 not	INV_318(EN_, EN);
 UDP_MUX2   U1250(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25LPLLU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25LPLLU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_319(EN_, EN);
 bufif1   U1254(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_320(EN_, EN);
 bufif1   U1257(PAD2, D2, DE2);
 not	INV_321(EN_, EN);
 UDP_MUX2   U1260(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25LPLL
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25LPLL(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_322(EN_, EN);
 bufif1   U1264(PAD1, D1, DE1);
 not	INV_323(EN_, EN);
 bufif1   U1267(PAD2, D2, DE2);
 not	INV_324(EN_, EN);
 UDP_MUX2   U1270(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25LPLNU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25LPLNU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_325(EN_, EN);
 bufif1   U1274(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_326(EN_, EN);
 bufif1   U1277(PAD2, D2, DE2);
 not	INV_327(EN_, EN);
 UDP_MUX2   U1280(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25LPLN
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25LPLN(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_328(EN_, EN);
 bufif1   U1284(PAD1, D1, DE1);
 not	INV_329(EN_, EN);
 bufif1   U1287(PAD2, D2, DE2);
 not	INV_330(EN_, EN);
 UDP_MUX2   U1290(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25LPLHU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25LPLHU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_331(EN_, EN);
 bufif1   U1294(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_332(EN_, EN);
 bufif1   U1297(PAD2, D2, DE2);
 not	INV_333(EN_, EN);
 UDP_MUX2   U1300(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25LPLH
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25LPLH(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_334(EN_, EN);
 bufif1   U1304(PAD1, D1, DE1);
 not	INV_335(EN_, EN);
 bufif1   U1307(PAD2, D2, DE2);
 not	INV_336(EN_, EN);
 UDP_MUX2   U1310(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25LPHLU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25LPHLU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_337(EN_, EN);
 bufif1   U1314(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_338(EN_, EN);
 bufif1   U1317(PAD2, D2, DE2);
 not	INV_339(EN_, EN);
 UDP_MUX2   U1320(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25LPHL
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25LPHL(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_340(EN_, EN);
 bufif1   U1324(PAD1, D1, DE1);
 not	INV_341(EN_, EN);
 bufif1   U1327(PAD2, D2, DE2);
 not	INV_342(EN_, EN);
 UDP_MUX2   U1330(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25LPHNU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25LPHNU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_343(EN_, EN);
 bufif1   U1334(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_344(EN_, EN);
 bufif1   U1337(PAD2, D2, DE2);
 not	INV_345(EN_, EN);
 UDP_MUX2   U1340(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25LPHN
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25LPHN(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_346(EN_, EN);
 bufif1   U1344(PAD1, D1, DE1);
 not	INV_347(EN_, EN);
 bufif1   U1347(PAD2, D2, DE2);
 not	INV_348(EN_, EN);
 UDP_MUX2   U1350(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25LPHHU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25LPHHU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_349(EN_, EN);
 bufif1   U1354(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_350(EN_, EN);
 bufif1   U1357(PAD2, D2, DE2);
 not	INV_351(EN_, EN);
 UDP_MUX2   U1360(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX25LPHH
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX25LPHH(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_352(EN_, EN);
 bufif1   U1364(PAD1, D1, DE1);
 not	INV_353(EN_, EN);
 bufif1   U1367(PAD2, D2, DE2);
 not	INV_354(EN_, EN);
 UDP_MUX2   U1370(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX33LLU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX33LLU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_355(EN_, EN);
 bufif1   U1374(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_356(EN_, EN);
 bufif1   U1377(PAD2, D2, DE2);
 not	INV_357(EN_, EN);
 UDP_MUX2   U1380(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX33LL
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX33LL(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_358(EN_, EN);
 bufif1   U1384(PAD1, D1, DE1);
 not	INV_359(EN_, EN);
 bufif1   U1387(PAD2, D2, DE2);
 not	INV_360(EN_, EN);
 UDP_MUX2   U1390(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX33LNU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX33LNU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_361(EN_, EN);
 bufif1   U1394(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_362(EN_, EN);
 bufif1   U1397(PAD2, D2, DE2);
 not	INV_363(EN_, EN);
 UDP_MUX2   U1400(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX33LN
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX33LN(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_364(EN_, EN);
 bufif1   U1404(PAD1, D1, DE1);
 not	INV_365(EN_, EN);
 bufif1   U1407(PAD2, D2, DE2);
 not	INV_366(EN_, EN);
 UDP_MUX2   U1410(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX33LHU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX33LHU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_367(EN_, EN);
 bufif1   U1414(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_368(EN_, EN);
 bufif1   U1417(PAD2, D2, DE2);
 not	INV_369(EN_, EN);
 UDP_MUX2   U1420(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX33LH
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX33LH(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_370(EN_, EN);
 bufif1   U1424(PAD1, D1, DE1);
 not	INV_371(EN_, EN);
 bufif1   U1427(PAD2, D2, DE2);
 not	INV_372(EN_, EN);
 UDP_MUX2   U1430(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX33PLU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX33PLU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_373(EN_, EN);
 bufif1   U1434(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_374(EN_, EN);
 bufif1   U1437(PAD2, D2, DE2);
 not	INV_375(EN_, EN);
 UDP_MUX2   U1440(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX33PL
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX33PL(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_376(EN_, EN);
 bufif1   U1444(PAD1, D1, DE1);
 not	INV_377(EN_, EN);
 bufif1   U1447(PAD2, D2, DE2);
 not	INV_378(EN_, EN);
 UDP_MUX2   U1450(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX33PNU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX33PNU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_379(EN_, EN);
 bufif1   U1454(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_380(EN_, EN);
 bufif1   U1457(PAD2, D2, DE2);
 not	INV_381(EN_, EN);
 UDP_MUX2   U1460(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX33PN
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX33PN(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_382(EN_, EN);
 bufif1   U1464(PAD1, D1, DE1);
 not	INV_383(EN_, EN);
 bufif1   U1467(PAD2, D2, DE2);
 not	INV_384(EN_, EN);
 UDP_MUX2   U1470(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX33PHU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX33PHU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_385(EN_, EN);
 bufif1   U1474(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_386(EN_, EN);
 bufif1   U1477(PAD2, D2, DE2);
 not	INV_387(EN_, EN);
 UDP_MUX2   U1480(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMX33PH
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & !EN + PAD2 & EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMX33PH(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_388(EN_, EN);
 bufif1   U1484(PAD1, D1, DE1);
 not	INV_389(EN_, EN);
 bufif1   U1487(PAD2, D2, DE2);
 not	INV_390(EN_, EN);
 UDP_MUX2   U1490(GL, PAD1, PAD2, EN_);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25LLU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25LLU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_391(EN_, EN);
 bufif1   U1494(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_392(EN_, EN);
 bufif1   U1497(PAD2, D2, DE2);
 not	INV_393(EN_, EN);
 UDP_MUX2   U1500(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25LL
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25LL(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_394(EN_, EN);
 bufif1   U1504(PAD1, D1, DE1);
 not	INV_395(EN_, EN);
 bufif1   U1507(PAD2, D2, DE2);
 not	INV_396(EN_, EN);
 UDP_MUX2   U1510(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25LNU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25LNU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_397(EN_, EN);
 bufif1   U1514(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_398(EN_, EN);
 bufif1   U1517(PAD2, D2, DE2);
 not	INV_399(EN_, EN);
 UDP_MUX2   U1520(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25LN
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25LN(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_400(EN_, EN);
 bufif1   U1524(PAD1, D1, DE1);
 not	INV_401(EN_, EN);
 bufif1   U1527(PAD2, D2, DE2);
 not	INV_402(EN_, EN);
 UDP_MUX2   U1530(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25LHU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25LHU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_403(EN_, EN);
 bufif1   U1534(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_404(EN_, EN);
 bufif1   U1537(PAD2, D2, DE2);
 not	INV_405(EN_, EN);
 UDP_MUX2   U1540(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25LH
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25LH(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_406(EN_, EN);
 bufif1   U1544(PAD1, D1, DE1);
 not	INV_407(EN_, EN);
 bufif1   U1547(PAD2, D2, DE2);
 not	INV_408(EN_, EN);
 UDP_MUX2   U1550(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25HLU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25HLU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_409(EN_, EN);
 bufif1   U1554(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_410(EN_, EN);
 bufif1   U1557(PAD2, D2, DE2);
 not	INV_411(EN_, EN);
 UDP_MUX2   U1560(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25HL
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25HL(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_412(EN_, EN);
 bufif1   U1564(PAD1, D1, DE1);
 not	INV_413(EN_, EN);
 bufif1   U1567(PAD2, D2, DE2);
 not	INV_414(EN_, EN);
 UDP_MUX2   U1570(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25HNU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25HNU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_415(EN_, EN);
 bufif1   U1574(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_416(EN_, EN);
 bufif1   U1577(PAD2, D2, DE2);
 not	INV_417(EN_, EN);
 UDP_MUX2   U1580(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25HN
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25HN(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_418(EN_, EN);
 bufif1   U1584(PAD1, D1, DE1);
 not	INV_419(EN_, EN);
 bufif1   U1587(PAD2, D2, DE2);
 not	INV_420(EN_, EN);
 UDP_MUX2   U1590(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25HHU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25HHU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_421(EN_, EN);
 bufif1   U1594(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_422(EN_, EN);
 bufif1   U1597(PAD2, D2, DE2);
 not	INV_423(EN_, EN);
 UDP_MUX2   U1600(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25HH
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25HH(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_424(EN_, EN);
 bufif1   U1604(PAD1, D1, DE1);
 not	INV_425(EN_, EN);
 bufif1   U1607(PAD2, D2, DE2);
 not	INV_426(EN_, EN);
 UDP_MUX2   U1610(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25LPLLU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25LPLLU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_427(EN_, EN);
 bufif1   U1614(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_428(EN_, EN);
 bufif1   U1617(PAD2, D2, DE2);
 not	INV_429(EN_, EN);
 UDP_MUX2   U1620(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25LPLL
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25LPLL(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_430(EN_, EN);
 bufif1   U1624(PAD1, D1, DE1);
 not	INV_431(EN_, EN);
 bufif1   U1627(PAD2, D2, DE2);
 not	INV_432(EN_, EN);
 UDP_MUX2   U1630(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25LPLNU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25LPLNU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_433(EN_, EN);
 bufif1   U1634(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_434(EN_, EN);
 bufif1   U1637(PAD2, D2, DE2);
 not	INV_435(EN_, EN);
 UDP_MUX2   U1640(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25LPLN
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25LPLN(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_436(EN_, EN);
 bufif1   U1644(PAD1, D1, DE1);
 not	INV_437(EN_, EN);
 bufif1   U1647(PAD2, D2, DE2);
 not	INV_438(EN_, EN);
 UDP_MUX2   U1650(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25LPLHU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25LPLHU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_439(EN_, EN);
 bufif1   U1654(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_440(EN_, EN);
 bufif1   U1657(PAD2, D2, DE2);
 not	INV_441(EN_, EN);
 UDP_MUX2   U1660(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25LPLH
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25LPLH(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_442(EN_, EN);
 bufif1   U1664(PAD1, D1, DE1);
 not	INV_443(EN_, EN);
 bufif1   U1667(PAD2, D2, DE2);
 not	INV_444(EN_, EN);
 UDP_MUX2   U1670(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25LPHLU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25LPHLU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_445(EN_, EN);
 bufif1   U1674(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_446(EN_, EN);
 bufif1   U1677(PAD2, D2, DE2);
 not	INV_447(EN_, EN);
 UDP_MUX2   U1680(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25LPHL
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25LPHL(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_448(EN_, EN);
 bufif1   U1684(PAD1, D1, DE1);
 not	INV_449(EN_, EN);
 bufif1   U1687(PAD2, D2, DE2);
 not	INV_450(EN_, EN);
 UDP_MUX2   U1690(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25LPHNU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25LPHNU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_451(EN_, EN);
 bufif1   U1694(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_452(EN_, EN);
 bufif1   U1697(PAD2, D2, DE2);
 not	INV_453(EN_, EN);
 UDP_MUX2   U1700(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25LPHN
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25LPHN(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_454(EN_, EN);
 bufif1   U1704(PAD1, D1, DE1);
 not	INV_455(EN_, EN);
 bufif1   U1707(PAD2, D2, DE2);
 not	INV_456(EN_, EN);
 UDP_MUX2   U1710(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25LPHHU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25LPHHU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_457(EN_, EN);
 bufif1   U1714(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_458(EN_, EN);
 bufif1   U1717(PAD2, D2, DE2);
 not	INV_459(EN_, EN);
 UDP_MUX2   U1720(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL25LPHH
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL25LPHH(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_460(EN_, EN);
 bufif1   U1724(PAD1, D1, DE1);
 not	INV_461(EN_, EN);
 bufif1   U1727(PAD2, D2, DE2);
 not	INV_462(EN_, EN);
 UDP_MUX2   U1730(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL33LLU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL33LLU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_463(EN_, EN);
 bufif1   U1734(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_464(EN_, EN);
 bufif1   U1737(PAD2, D2, DE2);
 not	INV_465(EN_, EN);
 UDP_MUX2   U1740(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL33LL
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL33LL(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_466(EN_, EN);
 bufif1   U1744(PAD1, D1, DE1);
 not	INV_467(EN_, EN);
 bufif1   U1747(PAD2, D2, DE2);
 not	INV_468(EN_, EN);
 UDP_MUX2   U1750(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL33LNU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL33LNU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_469(EN_, EN);
 bufif1   U1754(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_470(EN_, EN);
 bufif1   U1757(PAD2, D2, DE2);
 not	INV_471(EN_, EN);
 UDP_MUX2   U1760(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL33LN
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL33LN(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_472(EN_, EN);
 bufif1   U1764(PAD1, D1, DE1);
 not	INV_473(EN_, EN);
 bufif1   U1767(PAD2, D2, DE2);
 not	INV_474(EN_, EN);
 UDP_MUX2   U1770(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL33LHU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL33LHU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_475(EN_, EN);
 bufif1   U1774(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_476(EN_, EN);
 bufif1   U1777(PAD2, D2, DE2);
 not	INV_477(EN_, EN);
 UDP_MUX2   U1780(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL33LH
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL33LH(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_478(EN_, EN);
 bufif1   U1784(PAD1, D1, DE1);
 not	INV_479(EN_, EN);
 bufif1   U1787(PAD2, D2, DE2);
 not	INV_480(EN_, EN);
 UDP_MUX2   U1790(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL33PLU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL33PLU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_481(EN_, EN);
 bufif1   U1794(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_482(EN_, EN);
 bufif1   U1797(PAD2, D2, DE2);
 not	INV_483(EN_, EN);
 UDP_MUX2   U1800(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL33PL
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL33PL(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_484(EN_, EN);
 bufif1   U1804(PAD1, D1, DE1);
 not	INV_485(EN_, EN);
 bufif1   U1807(PAD2, D2, DE2);
 not	INV_486(EN_, EN);
 UDP_MUX2   U1810(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL33PNU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL33PNU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_487(EN_, EN);
 bufif1   U1814(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_488(EN_, EN);
 bufif1   U1817(PAD2, D2, DE2);
 not	INV_489(EN_, EN);
 UDP_MUX2   U1820(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL33PN
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL33PN(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_490(EN_, EN);
 bufif1   U1824(PAD1, D1, DE1);
 not	INV_491(EN_, EN);
 bufif1   U1827(PAD2, D2, DE2);
 not	INV_492(EN_, EN);
 UDP_MUX2   U1830(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL33PHU
 CELL TYPE : comb
 CELL LOGIC : PAD1#UP= D1@DE1 ; PAD2#UP= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL33PHU(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 tri1 PAD1;
 not	INV_493(EN_, EN);
 bufif1   U1834(PAD1, D1, DE1);
 tri1 PAD2;
 not	INV_494(EN_, EN);
 bufif1   U1837(PAD2, D2, DE2);
 not	INV_495(EN_, EN);
 UDP_MUX2   U1840(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMXL33PH
 CELL TYPE : comb
 CELL LOGIC : PAD1= D1@DE1 ; PAD2= D2@DE2 ;  GL=PAD1 & EN + PAD2 & !EN ; Y1=PAD1 ; Y2 = PAD2
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMXL33PH(GL,Y1,Y2,D1,DE1,D2,DE2,EN,PAD1,PAD2);
 input D1,DE1,D2,DE2,EN;
 output GL,Y1,Y2;
 inout PAD1,PAD2;
 wire NET_2_0, NET_2_1;

 not	INV_496(EN_, EN);
 bufif1   U1844(PAD1, D1, DE1);
 not	INV_497(EN_, EN);
 bufif1   U1847(PAD2, D2, DE2);
 not	INV_498(EN_, EN);
 UDP_MUX2   U1850(GL, PAD1, PAD2, EN);
 buf	BUF_U_03(Y1,PAD1);
 buf	BUF_U_04(Y2,PAD2);

       specify

                specparam tpdLH_DE1_to_PAD1 = (0.0:0.0:0.0);
                specparam tpdHL_DE1_to_PAD1 = (0.0:0.0:0.0);
		specparam tpdLZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZL_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHZ_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdZH_DE1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_PAD1 = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_PAD1 = (0.1:0.1:0.1);
                specparam tpdLH_DE2_to_PAD2 = (0.0:0.0:0.0);
                specparam tpdHL_DE2_to_PAD2 = (0.0:0.0:0.0);
		specparam tpdLZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZL_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHZ_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdZH_DE2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_PAD2 = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdHL_PAD1_to_Y1 = (0.1:0.1:0.1);
		specparam tpdLH_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam tpdHL_PAD2_to_Y2 = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D1)
		(DE1 => PAD1 ) = ( tpdLH_DE1_to_PAD1,tpdHL_DE1_to_PAD1,tpdLZ_DE1_to_PAD1,tpdZH_DE1_to_PAD1,tpdHZ_DE1_to_PAD1,tpdZL_DE1_to_PAD1);

	        (D1 => PAD1 ) = ( tpdLH_D1_to_PAD1,tpdHL_D1_to_PAD1);
		(D1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE1 => Y1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    //if(~D2)
		(DE2 => PAD2 ) = ( tpdLH_DE2_to_PAD2,tpdHL_DE2_to_PAD2,tpdLZ_DE2_to_PAD2,tpdZH_DE2_to_PAD2,tpdHZ_DE2_to_PAD2,tpdZL_DE2_to_PAD2);

	        (D2 => PAD2 ) = ( tpdLH_D2_to_PAD2,tpdHL_D2_to_PAD2);
		(D2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => GL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(D2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DE2 => Y2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD1 => GL ) = ( tpdLH_PAD1_to_GL, tpdHL_PAD1_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(PAD2 => GL ) = ( tpdLH_PAD2_to_GL, tpdHL_PAD2_to_GL );
		(PAD1 => Y1 ) = ( tpdLH_PAD1_to_Y1, tpdHL_PAD1_to_Y1 );
		(PAD2 => Y2 ) = ( tpdLH_PAD2_to_Y2, tpdHL_PAD2_to_Y2 );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ps / 1 ps

 module RAM256x9AA(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, WPE, RPE, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, RBLKB, WBLKB, PARODD;
 output  WPE, RPE, DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;
 reg WB_dlyd;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 reg ADDRS_MATCH;
 
 time RDB_re;
 time RDB_fe;
 time WRB_re;
 time WRB_fe;
 time WB_re;
 time WB_fe;
 time RBLKB_re;
 time RBLKB_fe;
 time WBLKB_re;
 time WBLKB_fe;
 time RADDR_change;
 time ADDRS_MATCH_re;
 time ADDRS_MATCH_fe;

 integer Write_OK;
 
/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);
 //buf #10 WBDELAYBUF ( WB_dlyd, WB_int );

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (RBLKB_int, RBLKB);
 buf BUF_U30 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U31 (WPE, WPE_int);
 buf OUTBUF_U32 (RPE, RPE_int);
 buf OUTBUF_U33 (DOS, DIS_int);
 buf OUTBUF_U34 (DO0, DO0_int);
 buf OUTBUF_U35 (DO1, DO1_int);
 buf OUTBUF_U36 (DO2, DO2_int);
 buf OUTBUF_U37 (DO3, DO3_int);
 buf OUTBUF_U38 (DO4, DO4_int);
 buf OUTBUF_U39 (DO5, DO5_int);
 buf OUTBUF_U40 (DO6, DO6_int);
 buf OUTBUF_U41 (DO7, DO7_int);
 buf OUTBUF_U42 (DO8, DO8_int);

/********************** initialization section ********************************/

  initial
    begin
      Write_OK = 0;
    end
    
/************************ edge detect section *********************************/

 always @ ( RDB_int )
 begin
   if ( RDB_int == 1'b1 )
     RDB_re = $time;
   else if ( RDB_int == 1'b0 )
     RDB_fe = $time;
 end

 always @ ( WRB_int )
 begin
   if ( WRB_int == 1'b1 )
     WRB_re = $time;
   else if ( WRB_int == 1'b0 )
     WRB_fe = $time;
 end

 always @ ( RBLKB_int )
 begin
   if ( RBLKB_int == 1'b1 )
     RBLKB_re = $time;
   else if ( RBLKB_int == 1'b0 ) 
     RBLKB_fe = $time;
 end

 always @ ( WBLKB_int )
 begin
   if ( WBLKB_int == 1'b1 )
     WBLKB_re = $time;
   else if ( WBLKB_int == 1'b0 )
     WBLKB_fe = $time;
 end

 always @ ( WB_int )
 begin
   WB_dlyd <= #1 WB_int;
   if ( WB_int == 1'b1 )
     WB_re = $time;
   else if ( WB_int == 1'b0 )
     WB_fe = $time;
   if ( WB_re < WB_fe )
     Write_OK = 1;
 end

 always @ ( `RAM_raddr )
 begin
   RADDR_change = $time;
 end

 always @ ( `RAM_raddr or `RAM_waddr )
 begin
   if ( `RAM_raddr === `RAM_waddr ) begin
     ADDRS_MATCH_re = $time;
     ADDRS_MATCH = 1'b1;
   end else begin
     ADDRS_MATCH_fe = $time;
     ADDRS_MATCH = 1'b0;
   end
 end
 /************************ the memory read section *********************************/

 // READ: ASYNC

 // there will be two blocks to start the async read 
 // the first block is the read enable controlled aync reading as following

 always @ ( RDB_int or RBLKB_int or `RAM_raddr or WRB_int or WBLKB_int or
            `RAM_waddr )
 begin : ASYNC_READ
   # 0;
   if ( `RAM_raddr >= 0 ) begin
     if ( `RAM_waddr === `RAM_raddr ) begin
       if (( RB_int == 1'b0 ) && 
           (( RDB_fe == $time ) || ( RBLKB_fe == $time ))  &&
           ( WB_int == 1'b1 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( WB_int == 1'b1 ) && 
                (( WRB_re == $time ) || ( WBLKB_re == $time ))  &&
                ( RB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b1 ) && 
                (( RDB_re == $time ) || ( RBLKB_re == $time ))  &&
                ( WB_dlyd == 1'b0 ))
                //( WB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( WB_int == 1'b1 ) && 
                ( ADDRS_MATCH_re == $time )  &&
                ( RB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
     end else begin // addresses not equal
       if (( RB_int == 1'b0 ) && ( WB_int == 1'b0 ) &&
           ( ADDRS_MATCH_fe == $time ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b0 ) && 
                (( RDB_fe == $time ) || ( RBLKB_fe == $time )))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b0 ) && ( RADDR_change == $time ))
         read_memory ( `RAM_do_out, `RAM_raddr );
     end
   end
   if (( RDB_int === 1'b0 ) && ( RBLKB_int === 1'b0 ))  
     begin
       f_address_is_x_g = address_is_x(`RAM_raddr);
       if (f_address_is_x_g == `RAM_TRUE)
         begin
           `RAM_do_out = 9'hx;
           //$display("Warning : Data on output bus unknown because of unknown read address");
         end
       //else
       //  read_memory (`RAM_do_out, `RAM_raddr);
     end
   else
     begin
       if((RDB_int === 1'bx) || (RBLKB === 1'bx)) begin
        `RAM_do_out = 9'hx;
        //$display("Warning : Data on output bus unknown because of unknown RDB or RBLKB bit");
       end
     end
 end

 // the following is the read parity checking, SYNC reading and aSYNC reading is different

 //always @(`RAM_do_out or negedge RB_int)
 always @ ( `RAM_do_out or PARODD_int )
   begin
     par_f = ram_par9(`RAM_do_out);    // previously  `RAM_par_do_out);
     RPE_int = par_f ^ PARODD_int;
   end



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: ASYNC, NO WCLK

 // input data Parity generating/chekcing section

 //always @(`RAM_par_di_in or DI8_int or negedge WB_int )
 always @(`RAM_par_di_in or DI8_int or PARODD_int )
   begin
     par_f = ram_par8(`RAM_par_di_in);
     par_f2 = par_f ^ DI8_int;
     WPE_int = par_f2 ^ PARODD_int;
     DI8_int_reg  = DI8_int;
   end

 // async memory write 

 always @ ( negedge WB_int or `RAM_di_in or `RAM_waddr )
   begin: ASYNC_WRITE
     if ( WB_int == 1'b0 && Write_OK == 1 ) begin
       write_memory (`RAM_waddr, `RAM_di_in );
     end

   end


 /************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for WADDR to WB
	     $setup(posedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // holdup time for WADDDR to WB 
	             $setup(posedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // setup and hold time for DATAIN DI[7:0] to WB 
	     $setup(posedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);

              // holdup time for DATAin to WB 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG); 

	      // pin to pin delay
	      (DI0 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI1 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI2 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI3 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI4 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI5 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI6 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI7 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI8 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);

             // write enable signal pulse width check
             $width(posedge WRB, 0.0, 0, NOTIFY_REG);
             $width(negedge WRB, 0.0, 0, NOTIFY_REG);
             $width(posedge WBLKB, 0.0, 0, NOTIFY_REG);
             $width(negedge WBLKB, 0.0, 0, NOTIFY_REG);

	    // async read. address controlled
	    (RADDR0 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);

	     // async read rdb controlled RB=RDB+RBLKB 
	     (RDB => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);

            // read enable signal pulse width
            $width(posedge RDB, 0.0, 0, NOTIFY_REG);
            $width(negedge RDB, 0.0, 0, NOTIFY_REG);
            $width(posedge RBLKB, 0.0, 0, NOTIFY_REG);
            $width(negedge RBLKB, 0.0, 0, NOTIFY_REG);
            // read address bit pulse width check
            $width(posedge RADDR0, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR0, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR1, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR1, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR2, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR2, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR3, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR3, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR4, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR4, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR5, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR5, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR6, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR6, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR7, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR7, 0.0, 0, NOTIFY_REG);


 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module RAM256x9AAP(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, RBLKB, WBLKB, PARODD;
 output  DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;
 reg WB_dlyd;
 integer Write_OK;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 reg ADDRS_MATCH;
 
 time RDB_re;
 time RDB_fe;
 time WRB_re;
 time WRB_fe;
 time WB_re;
 time WB_fe;
 time RBLKB_re;
 time RBLKB_fe;
 time WBLKB_re;
 time WBLKB_fe;
 time RADDR_change;
 time ADDRS_MATCH_re;
 time ADDRS_MATCH_fe;

/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (RBLKB_int, RBLKB);
 buf BUF_U30 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U31 (DOS, DIS_int);
 buf OUTBUF_U32 (DO0, DO0_int);
 buf OUTBUF_U33 (DO1, DO1_int);
 buf OUTBUF_U34 (DO2, DO2_int);
 buf OUTBUF_U35 (DO3, DO3_int);
 buf OUTBUF_U36 (DO4, DO4_int);
 buf OUTBUF_U37 (DO5, DO5_int);
 buf OUTBUF_U38 (DO6, DO6_int);
 buf OUTBUF_U39 (DO7, DO7_int);
 buf OUTBUF_U40 (DO8, DO8_int);

/********************** initialization section ********************************/

  initial
    begin
      Write_OK = 0;
    end
    
/************************ edge detect section *********************************/

 always @ ( RDB_int )
 begin
   if ( RDB_int == 1'b1 )
     RDB_re = $time;
   else if ( RDB_int == 1'b0 )
     RDB_fe = $time;
 end

 always @ ( WRB_int )
 begin
   if ( WRB_int == 1'b1 )
     WRB_re = $time;
   else if ( WRB_int == 1'b0 )
     WRB_fe = $time;
 end

 always @ ( RBLKB_int )
 begin
   if ( RBLKB_int == 1'b1 )
     RBLKB_re = $time;
   else if ( RBLKB_int == 1'b0 )
     RBLKB_fe = $time;
 end

 always @ ( WBLKB_int )
 begin
   if ( WBLKB_int == 1'b1 )
     WBLKB_re = $time;
   else if ( WBLKB_int == 1'b0 )
     WBLKB_fe = $time;
 end

 always @ ( WB_int )
 begin
   WB_dlyd <= #1 WB_int;
   if ( WB_int == 1'b1 )
     WB_re = $time;
   else if ( WB_int == 1'b0 )
     WB_fe = $time;
   if ( WB_re < WB_fe )
     Write_OK = 1;
 end
 
 always @ ( `RAM_raddr )
 begin
   RADDR_change = $time;
 end

 always @ ( `RAM_raddr or `RAM_waddr )
 begin
   if ( `RAM_raddr === `RAM_waddr ) begin
     ADDRS_MATCH_re = $time;
     ADDRS_MATCH = 1'b1;
   end else begin
     ADDRS_MATCH_fe = $time;
     ADDRS_MATCH = 1'b0;
   end
 end


/************************ the memory read section *********************************/

 // READ: ASYNC

 // there will be two blocks to start the async read 
 // the first block is the read enable controlled aync reading as following

 always @ ( RDB_int or RBLKB_int or `RAM_raddr or WRB_int or WBLKB_int or
            `RAM_waddr )
 begin : ASYNC_READ
   #0;
   if ( `RAM_raddr >= 0 ) begin
     if ( `RAM_waddr === `RAM_raddr ) begin
       if (( RB_int == 1'b0 ) && 
           (( RDB_fe == $time ) || ( RBLKB_fe == $time ))  &&
           ( WB_int == 1'b1 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( WB_int == 1'b1 ) && 
                (( WRB_re == $time ) || ( WBLKB_re == $time ))  &&
                ( RB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b1 ) && 
                (( RDB_re == $time ) || ( RBLKB_re == $time ))  &&
                ( WB_dlyd == 1'b0 ))
                //( WB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( WB_int == 1'b1 ) && 
                ( ADDRS_MATCH_re == $time )  &&
                ( RB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
     end else begin // addresses not equal
       if (( RB_int == 1'b0 ) && ( WB_int == 1'b0 ) &&
           ( ADDRS_MATCH_fe == $time ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b0 ) && 
                (( RDB_fe == $time ) || ( RBLKB_fe == $time )))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b0 ) && ( RADDR_change == $time ))
         read_memory ( `RAM_do_out, `RAM_raddr );
     end
   end
   if ((RDB_int === 1'b0) && (RBLKB_int === 1'b0))
     begin
       f_address_is_x_g = address_is_x(`RAM_raddr);
       if (f_address_is_x_g == `RAM_TRUE)
         begin
           `RAM_do_out = 9'hx;
           //$display("Warning : Data on output bus unknown because of unknown read address");
         end
       //else
       //  read_memory (`RAM_do_out, `RAM_raddr);
     end
   else
     begin
       if((RDB_int === 1'bx) || (RBLKB === 1'bx)) begin
        `RAM_do_out = 9'hx;
        //$display("Warning : Data on output bus unknown because of unknown RDB or RBLKB bit");
       end
     end
 end



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: ASYNC, NO WCLK

 // input data Parity generating/chekcing section

 always @(`RAM_par_di_in or DI8_int or PARODD_int )
   begin
     par_f = ram_par8(`RAM_par_di_in);
     WPE_int = par_f ^ PARODD_int;
     DI8_int_reg  = WPE_int;
   end

 // async memory write 

 always @ ( negedge WB_int or `RAM_di_in or DI8_int or `RAM_waddr )
   begin: ASYNC_WRITE
     if ( WB_int == 1'b0 && Write_OK == 1 ) begin
       write_memory (`RAM_waddr, `RAM_di_in );       
     end

   end


 /************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for WADDR to WB
	     $setup(posedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // holdup time for WADDDR to WB 
	             $setup(posedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // setup and hold time for DATAIN DI[7:0] to WB 
	     $setup(posedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);

              // holdup time for DATAin to WB 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG); 

	      // pin to pin delay

             // write enable signal pulse width check
             $width(posedge WRB, 0.0, 0, NOTIFY_REG);
             $width(negedge WRB, 0.0, 0, NOTIFY_REG);
             $width(posedge WBLKB, 0.0, 0, NOTIFY_REG);
             $width(negedge WBLKB, 0.0, 0, NOTIFY_REG);

	    // async read. address controlled
	    (RADDR0 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	     // async read rdb controlled RB=RDB+RBLKB 
	     (RDB => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);

            // read enable signal pulse width
            $width(posedge RDB, 0.0, 0, NOTIFY_REG);
            $width(negedge RDB, 0.0, 0, NOTIFY_REG);
            $width(posedge RBLKB, 0.0, 0, NOTIFY_REG);
            $width(negedge RBLKB, 0.0, 0, NOTIFY_REG);
            // read address bit pulse width check
            $width(posedge RADDR0, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR0, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR1, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR1, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR2, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR2, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR3, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR3, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR4, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR4, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR5, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR5, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR6, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR6, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR7, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR7, 0.0, 0, NOTIFY_REG);


 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module RAM256x9AST(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, RCLKS, WPE, RPE, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, RCLKS, RBLKB, WBLKB, PARODD;
 output  WPE, RPE, DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 time WB_re;
 time WB_fe;
 integer Write_OK;

/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (RCLKS_int, RCLKS);
 buf BUF_U30 (RBLKB_int, RBLKB);
 buf BUF_U31 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U32 (WPE, WPE_int);
 buf OUTBUF_U33 (RPE, RPE_int);
 buf OUTBUF_U34 (DOS, DIS_int);
 buf OUTBUF_U35 (DO0, DO0_int);
 buf OUTBUF_U36 (DO1, DO1_int);
 buf OUTBUF_U37 (DO2, DO2_int);
 buf OUTBUF_U38 (DO3, DO3_int);
 buf OUTBUF_U39 (DO4, DO4_int);
 buf OUTBUF_U40 (DO5, DO5_int);
 buf OUTBUF_U41 (DO6, DO6_int);
 buf OUTBUF_U42 (DO7, DO7_int);
 buf OUTBUF_U43 (DO8, DO8_int);

/********************** initialization section ********************************/

  initial
    begin
      Write_OK = 0;
    end
    



 always @ ( WB_int )
 begin
   if ( WB_int == 1'b1 )
     WB_re = $time;
   else if ( WB_int == 1'b0 )
     WB_fe = $time;
   if ( WB_re < WB_fe )
     Write_OK = 1;
 end

 
  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
      //WPE_int  = ~ WPE_int;
    end


/************************ the memory read section *********************************/

 // READ: SYNC with RCLK ;

 always @(posedge RCLKS_int)
  begin

    if((RDB_int === 1'b0) && (RBLKB_int === 1'b0))
      begin: SYNC_READ
      f_address_is_x_g = address_is_x(`RAM_raddr);
      if (f_address_is_x_g == `RAM_TRUE)
        begin
          `RAM_do_out = 9'hx;
          RPE_int = 1'bx;
          //   $display("Warning : Data on output bus unknown because of unknown read address");
        end
      else
        begin
               read_memory (`RAM_do_out, `RAM_raddr);

               par_f = ram_par9(`RAM_do_out);    // previously  `RAM_par_do_out);
               RPE_int = par_f ^ PARODD_int;
         end
      end
    else
      begin
       if((RDB_int === 1'bx) || (RBLKB_int === 1'bx))
        begin 
        `RAM_do_out = 9'hx;
        RPE_int = 1'bx;
        end
      end
  end

 // the following is the read parity checking, SYNC reading and aSYNC reading is different



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: ASYNC, NO WCLK

 // input data Parity generating/chekcing section

 always @(`RAM_par_di_in or DI8_int or PARODD_int )
   begin
     par_f = ram_par8(`RAM_par_di_in);
     par_f2 = par_f ^ DI8_int;
     WPE_int = par_f2 ^ PARODD_int;
     DI8_int_reg  = DI8_int;
   end

 // async memory write 

 always @( WB_int or `RAM_di_in or `RAM_waddr )
   begin: ASYNC_WRITE
     # 0;
     if ( WB_int == 1'b0 && Write_OK == 1 ) begin
       write_memory (`RAM_waddr, `RAM_di_in );

     end

   end


 /************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for WADDR to WB
	     $setup(posedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // holdup time for WADDDR to WB 
	             $setup(posedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // setup and hold time for DATAIN DI[7:0] to WB 
	     $setup(posedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);

              // holdup time for DATAin to WB 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG); 

	      // pin to pin delay
	      (DI0 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI1 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI2 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI3 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI4 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI5 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI6 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI7 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI8 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);

             // write enable signal pulse width check
             $width(posedge WRB, 0.0, 0, NOTIFY_REG);
             $width(negedge WRB, 0.0, 0, NOTIFY_REG);
             $width(posedge WBLKB, 0.0, 0, NOTIFY_REG);
             $width(negedge WBLKB, 0.0, 0, NOTIFY_REG);
	     // setup and hold time for RBD and RBLKB to RCLK
	     $setup(posedge RDB, posedge RCLKS &&& (RBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RBLKB_int == 1'b0), posedge RDB, 0.0, NOTIFY_REG);
	     $setup(posedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RBLKB, 0.0, NOTIFY_REG);
	     $setup(negedge RDB, posedge RCLKS &&& (RBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RBLKB_int == 1'b0), negedge RDB, 0.0, NOTIFY_REG);
	     $setup(negedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RBLKB, 0.0, NOTIFY_REG);

	     // setup/hold time for RADDR to CLK
	     $setup(posedge RADDR0, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR0, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR1, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR1, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR2, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR2, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR3, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR3, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR4, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR4, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR5, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR5, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR6, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR6, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR7, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR7, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR7, 0.0, NOTIFY_REG);

	    // path delay parameters
	     (RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // clock width 
	    $width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
            $width(negedge RCLKS, 0.0, 0, NOTIFY_REG);



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module RAM256x9ASTP(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, RCLKS, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, RCLKS, RBLKB, WBLKB, PARODD;
 output  DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 time WB_re;
 time WB_fe;
 integer Write_OK;

/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (RCLKS_int, RCLKS);
 buf BUF_U30 (RBLKB_int, RBLKB);
 buf BUF_U31 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U32 (DOS, DIS_int);
 buf OUTBUF_U33 (DO0, DO0_int);
 buf OUTBUF_U34 (DO1, DO1_int);
 buf OUTBUF_U35 (DO2, DO2_int);
 buf OUTBUF_U36 (DO3, DO3_int);
 buf OUTBUF_U37 (DO4, DO4_int);
 buf OUTBUF_U38 (DO5, DO5_int);
 buf OUTBUF_U39 (DO6, DO6_int);
 buf OUTBUF_U40 (DO7, DO7_int);
 buf OUTBUF_U41 (DO8, DO8_int);

/********************** initialization section ********************************/

  initial
    begin
      Write_OK = 0;
    end
    



 always @ ( WB_int )
 begin
   if ( WB_int == 1'b1 )
     WB_re = $time;
   else if ( WB_int == 1'b0 )
     WB_fe = $time;
   if ( WB_re < WB_fe )
     Write_OK = 1;
 end

 
 
/************************ the memory read section *********************************/

 // READ: SYNC with RCLK ;

 always @(posedge RCLKS_int)
  begin

    if((RDB_int === 1'b0) && (RBLKB_int === 1'b0))
      begin: SYNC_READ
      f_address_is_x_g = address_is_x(`RAM_raddr);
      if (f_address_is_x_g == `RAM_TRUE)
        begin
          `RAM_do_out = 9'hx;
          //   $display("Warning : Data on output bus unknown because of unknown read address");
        end
      else
        begin
               read_memory (`RAM_do_out, `RAM_raddr);
         end
      end
    else
      begin
       if((RDB_int === 1'bx) || (RBLKB_int === 1'bx))
        begin 
        `RAM_do_out = 9'hx;
        end
      end
  end



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: ASYNC, NO WCLK

 // input data Parity generating/chekcing section

 always @ ( `RAM_par_di_in or DI8_int or PARODD_int )
   begin
     par_f = ram_par8(`RAM_par_di_in);
     WPE_int = par_f ^ PARODD_int;
     DI8_int_reg  = WPE_int;
   end

 // async memory write 

 always @( WB_int or `RAM_di_in or `RAM_waddr )
   begin: ASYNC_WRITE
     # 0;
     if ( WB_int == 1'b0 && Write_OK == 1 ) begin
       write_memory (`RAM_waddr, `RAM_di_in );

     end

   end


 /************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for WADDR to WB
	     $setup(posedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // holdup time for WADDDR to WB 
	             $setup(posedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // setup and hold time for DATAIN DI[7:0] to WB 
	     $setup(posedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);

              // holdup time for DATAin to WB 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG); 

	      // pin to pin delay

             // write enable signal pulse width check
             $width(posedge WRB, 0.0, 0, NOTIFY_REG);
             $width(negedge WRB, 0.0, 0, NOTIFY_REG);
             $width(posedge WBLKB, 0.0, 0, NOTIFY_REG);
             $width(negedge WBLKB, 0.0, 0, NOTIFY_REG);
	     // setup and hold time for RBD and RBLKB to RCLK
	     $setup(posedge RDB, posedge RCLKS &&& (RBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RBLKB_int == 1'b0), posedge RDB, 0.0, NOTIFY_REG);
	     $setup(posedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RBLKB, 0.0, NOTIFY_REG);
	     $setup(negedge RDB, posedge RCLKS &&& (RBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RBLKB_int == 1'b0), negedge RDB, 0.0, NOTIFY_REG);
	     $setup(negedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RBLKB, 0.0, NOTIFY_REG);

	     // setup/hold time for RADDR to CLK
	     $setup(posedge RADDR0, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR0, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR1, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR1, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR2, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR2, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR3, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR3, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR4, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR4, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR5, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR5, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR6, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR6, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR7, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR7, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR7, 0.0, NOTIFY_REG);

	    // path delay parameters
	     (RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // clock width 
	    $width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
            $width(negedge RCLKS, 0.0, 0, NOTIFY_REG);



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module RAM256x9ASR(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, RCLKS, WPE, RPE, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, RCLKS, RBLKB, WBLKB, PARODD;
 output  WPE, RPE, DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg [8:0] RAM_do_out_stg1;
 reg RPE_stg1;
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 time WB_re;
 time WB_fe;
 integer Write_OK;

/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (RCLKS_int, RCLKS);
 buf BUF_U30 (RBLKB_int, RBLKB);
 buf BUF_U31 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U32 (WPE, WPE_int);
 buf OUTBUF_U33 (RPE, RPE_int);
 buf OUTBUF_U34 (DOS, DIS_int);
 buf OUTBUF_U35 (DO0, DO0_int);
 buf OUTBUF_U36 (DO1, DO1_int);
 buf OUTBUF_U37 (DO2, DO2_int);
 buf OUTBUF_U38 (DO3, DO3_int);
 buf OUTBUF_U39 (DO4, DO4_int);
 buf OUTBUF_U40 (DO5, DO5_int);
 buf OUTBUF_U41 (DO6, DO6_int);
 buf OUTBUF_U42 (DO7, DO7_int);
 buf OUTBUF_U43 (DO8, DO8_int);

/********************** initialization section ********************************/

  initial
    begin
      Write_OK = 0;
    end
    

  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
      RPE_stg1 = ~ RPE_stg1;
      //WPE_int  = ~ WPE_int;
    end


/************************ the memory read section *********************************/

 // READ: SYNC with RCLK ;

 always @(posedge RCLKS_int)
  begin

    `RAM_do_out <= RAM_do_out_stg1;
    RPE_int = RPE_stg1;

    if((RDB_int === 1'b0) && (RBLKB_int === 1'b0))
      begin: SYNC_READ
      f_address_is_x_g = address_is_x(`RAM_raddr);
      if (f_address_is_x_g == `RAM_TRUE)
        begin
          RAM_do_out_stg1 = 9'hx;
          RPE_stg1 = 1'bx;
          //   $display("Warning : Data on output bus unknown because of unknown read address");
        end
      else
        begin
          read_memory (RAM_do_out_stg1, `RAM_raddr);
          f_dout_is_x = do_is_x(RAM_do_out_stg1);

          if (f_dout_is_x == `RAM_TRUE) 
            RPE_stg1 = 1'bx;
          else
            begin
              par_f = ram_par9(RAM_do_out_stg1);    // get parity of the intermediate output
              //if ( PARODD_int === 1'bx || `RAM_par_di_in === 8'bxxxxxxxx )
              if ( PARODD_int === 1'bx || ram_par8(`RAM_par_di_in) === 1'bx )
                RPE_stg1 = 1'bx;
              else begin
                if (par_f !== PARODD_int)
                    RPE_stg1 = `RAM_TRUE;
                else  
                  RPE_stg1 = `RAM_FALSE;
              end
            end
         end
      end
    else
      begin
       if((RDB_int === 1'bx) || (RBLKB_int === 1'bx))
        begin 
        RAM_do_out_stg1 = 9'hx;
        RPE_stg1 = 1'bx;
        end
      end
  end

 // the following is the read parity checking, SYNC reading and aSYNC reading is different



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: ASYNC, NO WCLK

 // input data Parity generating/chekcing section

 always @ ( WB_int )
 begin
   if ( WB_int == 1'b1 )
     WB_re = $time;
   else if ( WB_int == 1'b0 )
     WB_fe = $time;
   if ( WB_re < WB_fe )
     Write_OK = 1;
 end

 always @ ( `RAM_par_di_in or DI8_int or PARODD_int )
   begin
     par_f = ram_par8(`RAM_par_di_in);
     par_f2 = par_f ^ DI8_int;
     WPE_int = par_f2 ^ PARODD_int;
     DI8_int_reg  = DI8_int;
   end

 // async memory write 

 always @( WB_int or `RAM_di_in )
   begin: ASYNC_WRITE
     # 0;
     if ( WB_int == 1'b0 && Write_OK == 1 ) begin
       write_memory (`RAM_waddr, `RAM_di_in );
     end

   end


 /************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for WADDR to WB
	     $setup(posedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // holdup time for WADDDR to WB 
	             $setup(posedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // setup and hold time for DATAIN DI[7:0] to WB 
	     $setup(posedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);

              // holdup time for DATAin to WB 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG); 

	      // pin to pin delay
	      (DI0 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI1 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI2 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI3 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI4 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI5 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI6 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI7 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI8 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);

             // write enable signal pulse width check
             $width(posedge WRB, 0.0, 0, NOTIFY_REG);
             $width(negedge WRB, 0.0, 0, NOTIFY_REG);
             $width(posedge WBLKB, 0.0, 0, NOTIFY_REG);
             $width(negedge WBLKB, 0.0, 0, NOTIFY_REG);
	     // setup and hold time for RBD and RBLKB to RCLK
	     $setup(posedge RDB, posedge RCLKS &&& (RBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RBLKB_int == 1'b0), posedge RDB, 0.0, NOTIFY_REG);
	     $setup(posedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RBLKB, 0.0, NOTIFY_REG);
	     $setup(negedge RDB, posedge RCLKS &&& (RBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RBLKB_int == 1'b0), negedge RDB, 0.0, NOTIFY_REG);
	     $setup(negedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RBLKB, 0.0, NOTIFY_REG);

	     // setup/hold time for RADDR to CLK
	     $setup(posedge RADDR0, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR0, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR1, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR1, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR2, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR2, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR3, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR3, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR4, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR4, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR5, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR5, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR6, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR6, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR7, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR7, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR7, 0.0, NOTIFY_REG);

	    // path delay parameters
	     (RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // clock width 
	    $width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
            $width(negedge RCLKS, 0.0, 0, NOTIFY_REG);



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module RAM256x9ASRP(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, RCLKS, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, RCLKS, RBLKB, WBLKB, PARODD;
 output  DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg [8:0] RAM_do_out_stg1;
 reg RPE_stg1;
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 time WB_re;
 time WB_fe;
 integer Write_OK;

/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (RCLKS_int, RCLKS);
 buf BUF_U30 (RBLKB_int, RBLKB);
 buf BUF_U31 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U32 (DOS, DIS_int);
 buf OUTBUF_U33 (DO0, DO0_int);
 buf OUTBUF_U34 (DO1, DO1_int);
 buf OUTBUF_U35 (DO2, DO2_int);
 buf OUTBUF_U36 (DO3, DO3_int);
 buf OUTBUF_U37 (DO4, DO4_int);
 buf OUTBUF_U38 (DO5, DO5_int);
 buf OUTBUF_U39 (DO6, DO6_int);
 buf OUTBUF_U40 (DO7, DO7_int);
 buf OUTBUF_U41 (DO8, DO8_int);

/********************** initialization section ********************************/

  initial
    begin
      Write_OK = 0;
    end
    

 always @ ( WB_int )
 begin
   if ( WB_int == 1'b1 )
     WB_re = $time;
   else if ( WB_int == 1'b0 )
     WB_fe = $time;
   if ( WB_re < WB_fe )
     Write_OK = 1;
 end

 
/************************ the memory read section *********************************/

 // READ: SYNC with RCLK ;

 always @(posedge RCLKS_int)
  begin

    `RAM_do_out <= RAM_do_out_stg1;
    RPE_int = RPE_stg1;

    if((RDB_int === 1'b0) && (RBLKB_int === 1'b0))
      begin: SYNC_READ
      f_address_is_x_g = address_is_x(`RAM_raddr);
      if (f_address_is_x_g == `RAM_TRUE)
        begin
          RAM_do_out_stg1 = 9'hx;
          //   $display("Warning : Data on output bus unknown because of unknown read address");
        end
      else
        begin
          read_memory (RAM_do_out_stg1, `RAM_raddr);
         end
      end
    else
      begin
       if((RDB_int === 1'bx) || (RBLKB_int === 1'bx))
        begin 
        RAM_do_out_stg1 = 9'hx;
        end
      end
  end



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: ASYNC, NO WCLK

 // input data Parity generating/chekcing section

 always @ ( `RAM_par_di_in or DI8_int or PARODD_int )
   begin
     par_f = ram_par8(`RAM_par_di_in);
     WPE_int = par_f ^ PARODD_int;
     DI8_int_reg  = WPE_int;
   end

 // async memory write 

 always @( WB_int or `RAM_di_in or `RAM_waddr )
   begin: ASYNC_WRITE
     # 0;
     if ( WB_int == 1'b0 && Write_OK == 1 ) begin
       write_memory (`RAM_waddr, `RAM_di_in );

     end

   end


 /************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for WADDR to WB
	     $setup(posedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // holdup time for WADDDR to WB 
	             $setup(posedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // setup and hold time for DATAIN DI[7:0] to WB 
	     $setup(posedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);

              // holdup time for DATAin to WB 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG); 

	      // pin to pin delay

             // write enable signal pulse width check
             $width(posedge WRB, 0.0, 0, NOTIFY_REG);
             $width(negedge WRB, 0.0, 0, NOTIFY_REG);
             $width(posedge WBLKB, 0.0, 0, NOTIFY_REG);
             $width(negedge WBLKB, 0.0, 0, NOTIFY_REG);
	     // setup and hold time for RBD and RBLKB to RCLK
	     $setup(posedge RDB, posedge RCLKS &&& (RBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RBLKB_int == 1'b0), posedge RDB, 0.0, NOTIFY_REG);
	     $setup(posedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RBLKB, 0.0, NOTIFY_REG);
	     $setup(negedge RDB, posedge RCLKS &&& (RBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RBLKB_int == 1'b0), negedge RDB, 0.0, NOTIFY_REG);
	     $setup(negedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RBLKB, 0.0, NOTIFY_REG);

	     // setup/hold time for RADDR to CLK
	     $setup(posedge RADDR0, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR0, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR1, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR1, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR2, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR2, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR3, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR3, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR4, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR4, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR5, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR5, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR6, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR6, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR7, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), posedge RADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR7, posedge RCLKS &&& (RB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RB_int == 1'b0), negedge RADDR7, 0.0, NOTIFY_REG);

	    // path delay parameters
	     (RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // clock width 
	    $width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
            $width(negedge RCLKS, 0.0, 0, NOTIFY_REG);



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module RAM256x9SA(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, WCLKS, WPE, RPE, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, WCLKS, RBLKB, WBLKB, PARODD;
 output  WPE, RPE, DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, WCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 reg WB_dlyd;
 reg ADDRS_MATCH;
 reg [7:0] WADDR;

 time RDB_re;
 time RDB_fe;
 time WB_re;
 time WB_fe;
 time RBLKB_re;
 time RBLKB_fe;
 time WCLKS_fe;
 time RADDR_change;
 time ADDRS_MATCH_re;
 time ADDRS_MATCH_fe;

/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (WCLKS_int, WCLKS);
 buf BUF_U30 (RBLKB_int, RBLKB);
 buf BUF_U31 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U32 (WPE, WPE_int);
 buf OUTBUF_U33 (RPE, RPE_int);
 buf OUTBUF_U34 (DOS, DIS_int);
 buf OUTBUF_U35 (DO0, DO0_int);
 buf OUTBUF_U36 (DO1, DO1_int);
 buf OUTBUF_U37 (DO2, DO2_int);
 buf OUTBUF_U38 (DO3, DO3_int);
 buf OUTBUF_U39 (DO4, DO4_int);
 buf OUTBUF_U40 (DO5, DO5_int);
 buf OUTBUF_U41 (DO6, DO6_int);
 buf OUTBUF_U42 (DO7, DO7_int);
 buf OUTBUF_U43 (DO8, DO8_int);

/************************ edge detect section *********************************/

 always @ ( RDB_int )
 begin
   if ( RDB_int == 1'b1 )
     RDB_re = $time;
   else if ( RDB_int == 1'b0 )
     RDB_fe = $time;
 end

 always @ ( RBLKB_int )
 begin
   if ( RBLKB_int == 1'b1 )
     RBLKB_re = $time;
   else if ( RBLKB_int == 1'b0 )
     RBLKB_fe = $time;
 end

 always @ ( posedge WCLKS_int )
 begin
   WADDR = `RAM_waddr;
 end

 always @ ( negedge WCLKS_int )
 begin
   if ( WCLKS_int == 1'b0 )
     WCLKS_fe = $time;
 end

 always @ ( WB_int )
 begin
   WB_dlyd <= #1 WB_int;
   if ( WB_int == 1'b1 )
     WB_re = $time;
   else if ( WB_int == 1'b0 )
     WB_fe = $time;
 end

 always @ ( `RAM_raddr )
 begin
   RADDR_change = $time;
 end

 //always @ ( `RAM_raddr or `RAM_waddr )
 always @ ( `RAM_raddr or WADDR )
 begin
   //if ( `RAM_raddr === `RAM_waddr ) begin
   if ( `RAM_raddr === WADDR ) begin
     ADDRS_MATCH_re = $time;
     ADDRS_MATCH = 1'b1;
   end else begin
     ADDRS_MATCH_fe = $time;
     ADDRS_MATCH = 1'b0;
   end
 end

/************************ the memory read section *********************************/

 // READ: ASYNC, not RCLK, READING TRIGGERED BY RADDR or REN

 // there will be two blocks to start the async read 
 // the first block is the read enable controlled aync reading as following

 always @ ( RDB_int or RBLKB_int or `RAM_raddr or negedge WCLKS_int )
 begin : ASYNC_READ
   # 0;
   if ( `RAM_raddr >= 0 ) begin
     //if ( `RAM_waddr === `RAM_raddr ) begin
     if ( WADDR === `RAM_raddr ) begin
       if (( RB_int == 1'b0 ) &&
           (( RDB_fe == $time ) || ( RBLKB_fe == $time ))  &&
           ( WCLKS_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( WCLKS_int == 1'b0 ) &&
                ( WCLKS_fe == $time )  &&
                ( RB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b1 ) &&
                (( RDB_re == $time ) || ( RBLKB_re == $time )) &&
                ( WB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RADDR_change == $time ) && ( RB_int == 1'b0 ) &&
                ( ! (( WB_int == 1'b0 ) && ( WCLKS_int == 1'b1 ))))
         read_memory ( `RAM_do_out, `RAM_raddr );
     end else begin // addresses not equal
       if (( RB_int == 1'b0 ) &&
           ( ADDRS_MATCH_fe == $time ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b0 ) &&
                (( RDB_fe == $time ) || ( RBLKB_fe == $time )))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b0 ) && ( RADDR_change == $time ))
         read_memory ( `RAM_do_out, `RAM_raddr );
     end
   end
   if ((RDB_int === 1'b0) && (RBLKB_int === 1'b0))
     begin
       f_address_is_x_g = address_is_x(`RAM_raddr);
       if (f_address_is_x_g == `RAM_TRUE)
         begin
           `RAM_do_out = 9'hx;
           //$display("Warning : Data on output bus unknown because of unknown read address");
         end
       //else
         //read_memory (`RAM_do_out, `RAM_raddr);
     end
   else
     begin
       if((RDB_int === 1'bx) || (RBLKB === 1'bx)) begin
        `RAM_do_out = 9'hx;
        //$display("Warning : Data on output bus unknown because of unknown RDB or RBLKB bit");
       end
     end
 end

 // the following is the read parity checking, SYNC reading and aSYNC reading is different

 always @ ( `RAM_do_out or negedge RB_int or PARODD_int )
   begin
     par_f = ram_par9(`RAM_do_out);    // previously  `RAM_par_do_out);
     RPE_int = par_f ^ PARODD_int;
   end



  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
    end


/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: SYNC with WCLK
 //always@(posedge WCLKS_int)
 always @ ( WCLKS_int )
   begin:  SYNC_WRITE

     // check parity
     par_f = ram_par8(`RAM_par_di_in);
     par_f2 = par_f ^ DI8_int;

     //if (( PARODD_int === 1'bx ) || ( `RAM_par_di_in === 8'bxxxxxxxx ) || 
     //    ( WCLKS_int === 1'bx ))

     if (( PARODD_int === 1'bx ) || ( WCLKS_int === 1'bx ))
       WPE_int = 1'bx;
     else if ( WCLKS_int == 1'b1 ) begin
       WPE_int = par_f2 ^ PARODD_int;
     end
     DI8_int_reg  = DI8;

     if (( WCLKS_int == 1'b1 ) && ( WRB_int == 1'b0 ) && ( WBLKB_int == 1'b0 ))
       begin
          write_memory (`RAM_waddr, `RAM_di_in );

         // when async read and sync write at same @, write should trigger read output bus changing...
         //if ((RB_int === 1'b0) && (`RAM_waddr === `RAM_raddr) && (`RAM_waddr >= 0)) begin
           //read_memory (`RAM_do_out, `RAM_raddr);
         //end
       end
     else begin
       if((WRB_int == 1'bx) || (WBLKB_int == 1'bx)) begin
         x_data_word(`RAM_waddr);
       end
     end
   end


   // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
      WPE_int  = ~ WPE_int;
    end

/************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for Data in, DI[7:0]
		$setup(posedge DI0, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     // holdup time for Data IN to WCLK;
		$hold(posedge WCLKS &&& (WB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG);

	    // setup/hold time for enable signal
	     $setup(posedge WRB, posedge WCLKS &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WBLKB_int == 1'b0), posedge WRB, 0.0, NOTIFY_REG);
	     $setup(posedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WBLKB, 0.0, NOTIFY_REG);
             $setup(negedge WRB, posedge WCLKS &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(posedge WCLKS &&& (WBLKB_int == 1'b0), negedge WRB, 0.0, NOTIFY_REG);
             $setup(negedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
             $hold(posedge WCLKS, negedge WBLKB, 0.0, NOTIFY_REG);

	    //setup/hold time for WADDR (write address) to WCLK
	     $setup(posedge WADDR0, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR0, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), negedge WADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR1, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR1, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), negedge WADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR2, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR2, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), negedge WADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR3, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR3, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), negedge WADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR4, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR4, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), negedge WADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR5, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR5, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), negedge WADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR6, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR6, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), negedge WADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR7, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR7, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), negedge WADDR7, 0.0, NOTIFY_REG);

	     // path delay from WCLK to WPE 
	     (WCLKS => WPE) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

	     // WCLK width
	      $width(posedge WCLKS, 0.0, 0, NOTIFY_REG);
              $width(negedge WCLKS, 0.0, 0, NOTIFY_REG);

	    // async read. address controlled
	    (RADDR0 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);

	     // async read rdb controlled RB=RDB+RBLKB 
	     (RDB => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);

            // read enable signal pulse width
            $width(posedge RDB, 0.0, 0, NOTIFY_REG);
            $width(negedge RDB, 0.0, 0, NOTIFY_REG);
            $width(posedge RBLKB, 0.0, 0, NOTIFY_REG);
            $width(negedge RBLKB, 0.0, 0, NOTIFY_REG);
            // read address bit pulse width check
            $width(posedge RADDR0, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR0, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR1, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR1, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR2, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR2, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR3, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR3, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR4, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR4, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR5, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR5, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR6, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR6, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR7, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR7, 0.0, 0, NOTIFY_REG);


 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module RAM256x9SAP(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, WCLKS, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, WCLKS, RBLKB, WBLKB, PARODD;
 output  DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, WCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;

 reg ADDRS_MATCH;
 reg [7:0] WADDR;

 time RDB_re;
 time RDB_fe;
 time WB_re;
 time WB_fe;
 time RBLKB_re;
 time RBLKB_fe;
 time WCLKS_fe;
 time RADDR_change;
 time ADDRS_MATCH_re;
 time ADDRS_MATCH_fe;

/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (WCLKS_int, WCLKS);
 buf BUF_U30 (RBLKB_int, RBLKB);
 buf BUF_U31 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U32 (DOS, DIS_int);
 buf OUTBUF_U33 (DO0, DO0_int);
 buf OUTBUF_U34 (DO1, DO1_int);
 buf OUTBUF_U35 (DO2, DO2_int);
 buf OUTBUF_U36 (DO3, DO3_int);
 buf OUTBUF_U37 (DO4, DO4_int);
 buf OUTBUF_U38 (DO5, DO5_int);
 buf OUTBUF_U39 (DO6, DO6_int);
 buf OUTBUF_U40 (DO7, DO7_int);
 buf OUTBUF_U41 (DO8, DO8_int);

/************************ edge detect section *********************************/

 always @ ( RDB_int )
 begin
   if ( RDB_int == 1'b1 )
     RDB_re = $time;
   else if ( RDB_int == 1'b0 )
     RDB_fe = $time;
 end

 always @ ( RBLKB_int )
 begin
   if ( RBLKB_int == 1'b1 )
     RBLKB_re = $time;
   else if ( RBLKB_int == 1'b0 )
     RBLKB_fe = $time;
 end

 always @ ( posedge WCLKS_int )
 begin
   WADDR = `RAM_waddr;
 end

 always @ ( negedge WCLKS_int )
 begin
   if ( WCLKS_int == 1'b0 )
     WCLKS_fe = $time;
 end

 always @ ( WB_int )
 begin
   if ( WB_int == 1'b1 )
     WB_re = $time;
   else if ( WB_int == 1'b0 )
     WB_fe = $time;
 end

 always @ ( `RAM_raddr )
 begin
   RADDR_change = $time;
 end

 //always @ ( `RAM_raddr or `RAM_waddr )
 always @ ( `RAM_raddr or WADDR )
 begin
   //if ( `RAM_raddr === `RAM_waddr ) begin
   if ( `RAM_raddr === WADDR ) begin
     ADDRS_MATCH_re = $time;
     ADDRS_MATCH = 1'b1;
   end else begin
     ADDRS_MATCH_fe = $time;
     ADDRS_MATCH = 1'b0;
   end
 end

/************************ the memory read section *********************************/

 // READ: ASYNC, not RCLK, READING TRIGGERED BY RADDR or REN

 // there will be two blocks to start the async read 
 // the first block is the read enable controlled aync reading as following

 always @ ( RDB_int or RBLKB_int or `RAM_raddr or negedge WCLKS_int )
 begin : ASYNC_READ
   # 0;
   if ( `RAM_raddr >= 0 ) begin
     //if ( `RAM_waddr === `RAM_raddr ) begin
     if ( WADDR === `RAM_raddr ) begin
       if (( RB_int == 1'b0 ) &&
           (( RDB_fe == $time ) || ( RBLKB_fe == $time ))  &&
           ( WCLKS_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( WCLKS_int == 1'b0 ) &&
                ( WCLKS_fe == $time )  &&
                ( RB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b1 ) &&
                (( RDB_re == $time ) || ( RBLKB_re == $time )) &&
                ( WB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RADDR_change == $time ) && ( RB_int == 1'b0 ) &&
                ( ! (( WB_int == 1'b0 ) && ( WCLKS_int == 1'b1 ))))
         read_memory ( `RAM_do_out, `RAM_raddr );
     end else begin // addresses not equal
       if (( RB_int == 1'b0 ) && 
           ( ADDRS_MATCH_fe == $time ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b0 ) &&
                (( RDB_fe == $time ) || ( RBLKB_fe == $time )))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b0 ) && ( RADDR_change == $time ))
         read_memory ( `RAM_do_out, `RAM_raddr );
     end
   end
   if ((RDB_int === 1'b0) && (RBLKB_int === 1'b0))
     begin
       f_address_is_x_g = address_is_x(`RAM_raddr);
       if (f_address_is_x_g == `RAM_TRUE)
         begin
           `RAM_do_out = 9'hx;
           //$display("Warning : Data on output bus unknown because of unknown read address");
         end
       //else
         //read_memory (`RAM_do_out, `RAM_raddr);
     end
   else
     begin
       if((RDB_int === 1'bx) || (RBLKB === 1'bx)) begin
        `RAM_do_out = 9'hx;
        //$display("Warning : Data on output bus unknown because of unknown RDB or RBLKB bit");
       end
     end
 end



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: SYNC with WCLK
 always @ ( WCLKS_int )
   begin:  SYNC_WRITE

     // first generate or check the parity it
     par_f = ram_par8(`RAM_par_di_in);
     WPE_int = par_f ^ PARODD_int;
     DI8_int_reg  = WPE_int;

     if (( WCLKS_int == 1'b1 ) && ( WRB_int == 1'b0 ) && ( WBLKB_int == 1'b0 ))
       begin
         write_memory (`RAM_waddr, `RAM_di_in );

         // when async read and sync write at same @, write should trigger read output bus changing...
         //if ((RB_int === 1'b0) && (`RAM_waddr === `RAM_raddr) && (`RAM_waddr >= 0)) begin
         //  read_memory (`RAM_do_out, `RAM_raddr);
         //end
       end
     else begin
       if((WRB == 1'bx) || (WBLKB_int == 1'bx)) begin
         x_data_word(`RAM_waddr);
       end
     end
   end


 /************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for Data in, DI[7:0]
		$setup(posedge DI0, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     // holdup time for Data IN to WCLK;
		$hold(posedge WCLKS &&& (WB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (WB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG);

	    // setup/hold time for enable signal
	     $setup(posedge WRB, posedge WCLKS &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WBLKB_int == 1'b0), posedge WRB, 0.0, NOTIFY_REG);
	     $setup(posedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WBLKB, 0.0, NOTIFY_REG);
             $setup(negedge WRB, posedge WCLKS &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(posedge WCLKS &&& (WBLKB_int == 1'b0), negedge WRB, 0.0, NOTIFY_REG);
             $setup(negedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
             $hold(posedge WCLKS, negedge WBLKB, 0.0, NOTIFY_REG);

	    //setup/hold time for WADDR (write address) to WCLK
	     $setup(posedge WADDR0, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR0, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), negedge WADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR1, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR1, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), negedge WADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR2, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR2, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), negedge WADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR3, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR3, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), negedge WADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR4, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR4, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), negedge WADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR5, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR5, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), negedge WADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR6, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR6, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), negedge WADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR7, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR7, posedge WCLKS &&& (WB_int == 1'b0), 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS &&& (WB_int == 1'b0), negedge WADDR7, 0.0, NOTIFY_REG);

	     // WCLK width
	      $width(posedge WCLKS, 0.0, 0, NOTIFY_REG);
              $width(negedge WCLKS, 0.0, 0, NOTIFY_REG);

	    // async read. address controlled
	    (RADDR0 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	     // async read rdb controlled RB=RDB+RBLKB 
	     (RDB => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    